/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.lifecycle.phases;

import java.util.HashSet;
import java.util.Set;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.lifecycle.LifecycleStateEnabled;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.api.util.func.CheckedConsumer;
import org.mule.runtime.core.internal.lifecycle.phases.DefaultLifecycleObjectSorter;
import org.mule.runtime.core.internal.lifecycle.phases.LifecycleObjectSorter;
import org.mule.runtime.core.internal.lifecycle.phases.LifecyclePhase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLifecyclePhase
implements LifecyclePhase {
    protected final transient Logger logger = LoggerFactory.getLogger(DefaultLifecyclePhase.class);
    private final CheckedConsumer<Object> lifecycleInvoker;
    protected Class<?>[] orderedLifecycleTypes;
    private Class<?>[] ignoredObjectTypes;
    private final String name;
    private Set<String> supportedPhases;

    public DefaultLifecyclePhase(String name, CheckedConsumer<Object> lifecycleInvoker) {
        this.name = name;
        this.lifecycleInvoker = lifecycleInvoker;
    }

    @Override
    public LifecycleObjectSorter newLifecycleObjectSorter() {
        return new DefaultLifecycleObjectSorter(this.orderedLifecycleTypes);
    }

    protected boolean ignoreType(Class<?> type) {
        if (this.ignoredObjectTypes == null) {
            return false;
        }
        for (Class<?> ignoredType : this.ignoredObjectTypes) {
            if (!ignoredType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    protected void setOrderedLifecycleTypes(Class<?>[] orderedLifecycleTypes) {
        this.orderedLifecycleTypes = orderedLifecycleTypes;
    }

    protected void setIgnoredObjectTypes(Class<?>[] ignorredObjectTypes) {
        this.ignoredObjectTypes = ignorredObjectTypes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void registerSupportedPhase(String phase) {
        if (this.supportedPhases == null) {
            this.supportedPhases = new HashSet<String>();
        }
        this.supportedPhases.add(phase);
    }

    @Override
    public void applyLifecycle(Object o) throws LifecycleException {
        if (o == null) {
            return;
        }
        if (this.ignoreType(o.getClass())) {
            return;
        }
        if (o instanceof LifecycleStateEnabled) {
            if (((LifecycleStateEnabled)o).getLifecycleState().isPhaseComplete(this.getName())) {
                return;
            }
            if (!((LifecycleStateEnabled)o).getLifecycleState().isValidTransition(this.getName())) {
                return;
            }
        }
        try {
            this.lifecycleInvoker.accept(o);
        }
        catch (Exception e) {
            Throwable t = e.getCause();
            if (t instanceof LifecycleException) {
                throw (LifecycleException)t;
            }
            t = ExceptionUtils.extractOfType(e, LifecycleException.class).orElse(null);
            if (t != null) {
                throw (LifecycleException)t;
            }
            throw new LifecycleException(CoreMessages.failedToInvokeLifecycle(this.name, o), ExceptionHelper.getNonMuleException(ExceptionHelper.unwrap(e)), o);
        }
    }
}

