/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.soap.internal.loader;

import java.lang.reflect.Type;
import java.util.function.Supplier;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.connection.ConnectionManagementType;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclarer;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.soap.MessageDispatcherProvider;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.internal.loader.delegate.ParameterModelsLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.delegate.StereotypeModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.property.ConnectionTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaExtensionModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.ParameterDeclarationContext;
import org.mule.runtime.module.extension.soap.internal.loader.type.runtime.SoapServiceProviderWrapper;
import org.mule.runtime.module.extension.soap.internal.runtime.connection.ForwardingSoapClient;

public class SoapServiceProviderDeclarer {
    public static final String TRANSPORT_PARAM = "Transport".toLowerCase();
    private final ParameterModelsLoaderDelegate parametersLoader;
    private final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    private final StereotypeModelLoaderDelegate stereotypeDelegate;
    private final ExtensionLoadingContext loadingContext;

    SoapServiceProviderDeclarer(ExtensionDeclarer extensionDeclarer, Supplier<StereotypeModelLoaderDelegate> stereotypeModelLoader, StereotypeModelLoaderDelegate stereotypeDelegate, ExtensionLoadingContext loadingContext) {
        this.parametersLoader = new ParameterModelsLoaderDelegate(stereotypeModelLoader, type -> ExtensionMetadataTypeUtils.registerType(extensionDeclarer, type));
        this.stereotypeDelegate = stereotypeDelegate;
        this.loadingContext = loadingContext;
    }

    public void declare(ConfigurationDeclarer configDeclarer, SoapServiceProviderWrapper provider, boolean hasCustomTransports) {
        String description = provider.getDescription();
        String providerName = provider.getAlias();
        ConnectionProviderDeclarer providerDeclarer = configDeclarer.withConnectionProvider(providerName).describedAs(description).withModelProperty(new ConnectionTypeModelProperty(ForwardingSoapClient.class)).withModelProperty(new ImplementingTypeModelProperty(provider.getDeclaringClass().get())).withConnectionManagementType(ConnectionManagementType.POOLING).supportsConnectivityTesting(provider.supportsConnectivityTesting()).withStereotype(this.stereotypeDelegate.getDefaultConnectionProviderStereotype(providerName));
        ParameterDeclarationContext context = new ParameterDeclarationContext("Service Provider", providerName, this.loadingContext);
        this.parametersLoader.declare(providerDeclarer, JavaExtensionModelParserUtils.getParameterGroupParsers(provider.getParameters(), context));
        if (hasCustomTransports) {
            ((ParameterDeclarer)((ParameterDeclarer)((ParameterDeclarer)providerDeclarer.onParameterGroup("Transport Configuration").withRequiredParameter(TRANSPORT_PARAM).withDisplayModel(DisplayModel.builder().displayName("Transport Configuration").build())).ofType(this.typeLoader.load((Type)((Object)MessageDispatcherProvider.class)))).withLayout(LayoutModel.builder().order(1).tabName("Transport").build())).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        }
    }
}

