/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.application;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.memory.management.MemoryManagementService;
import org.mule.runtime.api.service.ServiceRepository;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.internal.util.MuleContainerUtils;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.artifact.ArtifactConfigurationProcessor;
import org.mule.runtime.deployment.model.api.builder.ApplicationClassLoaderBuilder;
import org.mule.runtime.deployment.model.api.builder.ApplicationClassLoaderBuilderFactory;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPlugin;
import org.mule.runtime.deployment.model.api.plugin.resolver.PluginDependenciesResolver;
import org.mule.runtime.deployment.model.internal.DefaultRegionPluginClassLoadersFactory;
import org.mule.runtime.internal.memory.management.ArtifactMemoryManagementService;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.artifact.activation.api.descriptor.DeployableArtifactDescriptorCreator;
import org.mule.runtime.module.artifact.activation.api.descriptor.DeployableArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.activation.api.descriptor.DomainDescriptorResolutionException;
import org.mule.runtime.module.artifact.activation.api.descriptor.DomainDescriptorResolver;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionModelLoaderRepository;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;
import org.mule.runtime.module.deployment.impl.internal.application.ApplicationWrapper;
import org.mule.runtime.module.deployment.impl.internal.application.DefaultMuleApplication;
import org.mule.runtime.module.deployment.impl.internal.application.MuleApplicationPolicyProvider;
import org.mule.runtime.module.deployment.impl.internal.artifact.AbstractDeployableArtifactFactory;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.AmbiguousDomainReferenceException;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainNotFoundException;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainRepository;
import org.mule.runtime.module.deployment.impl.internal.plugin.DefaultArtifactPlugin;
import org.mule.runtime.module.deployment.impl.internal.policy.DefaultPolicyInstanceProviderFactory;
import org.mule.runtime.module.deployment.impl.internal.policy.DefaultPolicyTemplateFactory;
import org.mule.runtime.module.deployment.impl.internal.policy.PolicyTemplateClassLoaderBuilderFactory;
import org.mule.runtime.module.deployment.impl.internal.util.DeploymentPropertiesUtils;
import org.mule.runtime.module.license.api.LicenseValidator;

public class DefaultApplicationFactory
extends AbstractDeployableArtifactFactory<ApplicationDescriptor, Application>
implements ArtifactFactory<ApplicationDescriptor, Application> {
    private final DeployableArtifactDescriptorFactory deployableArtifactDescriptorFactory;
    private final DomainRepository domainRepository;
    private final ApplicationClassLoaderBuilderFactory applicationClassLoaderBuilderFactory;
    private final ServiceRepository serviceRepository;
    private final ExtensionModelLoaderRepository extensionModelLoaderRepository;
    private final ClassLoaderRepository classLoaderRepository;
    private final PolicyTemplateClassLoaderBuilderFactory policyTemplateClassLoaderBuilderFactory;
    private final PluginDependenciesResolver pluginDependenciesResolver;
    private final LicenseValidator licenseValidator;

    public DefaultApplicationFactory(ApplicationClassLoaderBuilderFactory applicationClassLoaderBuilderFactory, DeployableArtifactDescriptorFactory deployableArtifactDescriptorFactory, DomainRepository domainRepository, ServiceRepository serviceRepository, ExtensionModelLoaderRepository extensionModelLoaderRepository, ClassLoaderRepository classLoaderRepository, PolicyTemplateClassLoaderBuilderFactory policyTemplateClassLoaderBuilderFactory, PluginDependenciesResolver pluginDependenciesResolver, LicenseValidator licenseValidator, LockFactory runtimeLockFactory, MemoryManagementService memoryManagementService, ArtifactConfigurationProcessor artifactConfigurationProcessor) {
        super(licenseValidator, runtimeLockFactory, memoryManagementService, artifactConfigurationProcessor);
        Preconditions.checkArgument(applicationClassLoaderBuilderFactory != null, "Application classloader builder factory cannot be null");
        Preconditions.checkArgument(deployableArtifactDescriptorFactory != null, "Deployable artifact descriptor factory cannot be null");
        Preconditions.checkArgument(domainRepository != null, "Domain repository cannot be null");
        Preconditions.checkArgument(serviceRepository != null, "Service repository cannot be null");
        Preconditions.checkArgument(extensionModelLoaderRepository != null, "extensionModelLoaderRepository cannot be null");
        Preconditions.checkArgument(classLoaderRepository != null, "classLoaderRepository cannot be null");
        Preconditions.checkArgument(policyTemplateClassLoaderBuilderFactory != null, "policyClassLoaderBuilderFactory cannot be null");
        Preconditions.checkArgument(pluginDependenciesResolver != null, "pluginDependenciesResolver cannot be null");
        Preconditions.checkArgument(memoryManagementService != null, "memoryManagementService cannot be null");
        Preconditions.checkArgument(artifactConfigurationProcessor != null, "artifactConfigurationProcessor cannot be null");
        this.classLoaderRepository = classLoaderRepository;
        this.applicationClassLoaderBuilderFactory = applicationClassLoaderBuilderFactory;
        this.deployableArtifactDescriptorFactory = deployableArtifactDescriptorFactory;
        this.domainRepository = domainRepository;
        this.serviceRepository = serviceRepository;
        this.extensionModelLoaderRepository = extensionModelLoaderRepository;
        this.policyTemplateClassLoaderBuilderFactory = policyTemplateClassLoaderBuilderFactory;
        this.pluginDependenciesResolver = pluginDependenciesResolver;
        this.licenseValidator = licenseValidator;
    }

    @Override
    protected Application doCreateArtifact(File artifactDir, Optional<Properties> properties) throws IOException {
        String appName = artifactDir.getName();
        if (appName.contains(" ")) {
            throw new IllegalArgumentException("Mule application name may not contain spaces: " + appName);
        }
        DeployableArtifactDescriptor descriptor = this.createArtifactDescriptor(artifactDir, (Optional)properties);
        return this.createArtifact((ApplicationDescriptor)descriptor);
    }

    @Override
    public File getArtifactDir() {
        return MuleContainerUtils.getMuleAppsDir();
    }

    @Override
    public ApplicationDescriptor createArtifactDescriptor(File artifactLocation, Optional<Properties> deploymentProperties) {
        return this.createArtifactDescriptor(artifactLocation, this.createDeployableProjectModel(artifactLocation, false), deploymentProperties);
    }

    public ApplicationDescriptor createArtifactDescriptor(File artifactLocation, DeployableProjectModel model, Optional<Properties> deploymentProperties) {
        String appName = artifactLocation.getName();
        Optional<Properties> effectiveProperties = deploymentProperties.isPresent() ? deploymentProperties : DeploymentPropertiesUtils.getPersistedDeploymentProperties(appName);
        Map<String, String> properties = effectiveProperties.map(dp -> Maps.fromProperties((Properties)dp)).orElse(Collections.emptyMap());
        DomainDescriptorResolver domainDescriptorResolver = (domainName, bundleDescriptor) -> (DomainDescriptor)this.getDomainForDescriptor(domainName, bundleDescriptor, artifactLocation).getDescriptor();
        return this.deployableArtifactDescriptorFactory.createApplicationDescriptor(model, properties, domainDescriptorResolver, this.getDescriptorCreator());
    }

    private DeployableArtifactDescriptorCreator<ApplicationDescriptor> getDescriptorCreator() {
        return new DeployableArtifactDescriptorCreator<ApplicationDescriptor>(){

            @Override
            public ApplicationDescriptor create(String name) {
                return new org.mule.runtime.deployment.model.api.application.ApplicationDescriptor(name);
            }

            @Override
            public ApplicationDescriptor create(String name, Optional<Properties> deploymentProperties) {
                return new org.mule.runtime.deployment.model.api.application.ApplicationDescriptor(name, deploymentProperties);
            }
        };
    }

    public Application createArtifact(ApplicationDescriptor descriptor) throws IOException {
        Domain domain = this.getDomainForDescriptor(descriptor);
        ApplicationClassLoaderBuilder artifactClassLoaderBuilder = this.applicationClassLoaderBuilderFactory.createArtifactClassLoaderBuilder();
        MuleDeployableArtifactClassLoader applicationClassLoader = artifactClassLoaderBuilder.setDomainParentClassLoader((ArtifactClassLoader)((Object)domain.getArtifactClassLoader().getClassLoader().getParent())).setArtifactDescriptor(descriptor).build();
        List<ArtifactPlugin> artifactPlugins = this.createArtifactPluginList(applicationClassLoader, new ArrayList<ArtifactPluginDescriptor>(descriptor.getPlugins()));
        MuleApplicationPolicyProvider applicationPolicyProvider = new MuleApplicationPolicyProvider(new DefaultPolicyTemplateFactory(this.policyTemplateClassLoaderBuilderFactory, this.pluginDependenciesResolver, this.licenseValidator), new DefaultPolicyInstanceProviderFactory(this.serviceRepository, this.classLoaderRepository, this.extensionModelLoaderRepository, this.getArtifactConfigurationProcessor()));
        DefaultMuleApplication delegate = new DefaultMuleApplication(descriptor, applicationClassLoader, artifactPlugins, this.domainRepository, this.serviceRepository, this.extensionModelLoaderRepository, descriptor.getArtifactLocation(), this.classLoaderRepository, applicationPolicyProvider, this.getRuntimeLockFactory(), new ArtifactMemoryManagementService(this.getMemoryManagementService()), this.getArtifactConfigurationProcessor());
        applicationPolicyProvider.setApplication(delegate);
        return new ApplicationWrapper(delegate);
    }

    private Domain getDomainForDescriptor(ApplicationDescriptor descriptor) {
        return this.getDomainForDescriptor(descriptor.getDomainName(), descriptor.getDomainDescriptor().orElse(null), descriptor.getArtifactLocation());
    }

    private Domain getDomainForDescriptor(String domainName, BundleDescriptor domainBundleDescriptor, File artifactLocation) {
        try {
            return domainName != null ? this.domainRepository.getDomain(domainName) : this.domainRepository.getCompatibleDomain(domainBundleDescriptor);
        }
        catch (DomainNotFoundException e) {
            throw new DeploymentException(I18nMessageFactory.createStaticMessage(String.format("Domain '%s' has to be deployed in order to deploy Application in '%s'", e.getDomainName(), artifactLocation.toString())), (Throwable)e);
        }
        catch (DomainDescriptorResolutionException e) {
            throw new DeploymentException(I18nMessageFactory.createStaticMessage(String.format("Problems found while retrieving domain '%s'", domainName)), (Throwable)e);
        }
        catch (AmbiguousDomainReferenceException e) {
            throw new DeploymentException(I18nMessageFactory.createStaticMessage("Multiple domains were found"), (Throwable)e);
        }
    }

    private List<ArtifactPlugin> createArtifactPluginList(MuleDeployableArtifactClassLoader applicationClassLoader, List<ArtifactPluginDescriptor> plugins) {
        return plugins.stream().map(artifactPluginDescriptor -> new DefaultArtifactPlugin(DefaultRegionPluginClassLoadersFactory.getArtifactPluginId(applicationClassLoader.getArtifactId(), artifactPluginDescriptor.getName()), (ArtifactPluginDescriptor)artifactPluginDescriptor, applicationClassLoader.getArtifactPluginClassLoaders().stream().filter(artifactClassLoader -> {
            String artifactPluginDescriptorName = "/plugin/" + artifactPluginDescriptor.getName();
            return artifactClassLoader.getArtifactId().endsWith(artifactPluginDescriptorName);
        }).findFirst().get())).collect(Collectors.toList());
    }
}

