/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.repository.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.api.model.RemoteRepository;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.internal.util.MuleContainerUtils;
import org.mule.runtime.module.repository.api.RepositoryService;
import org.mule.runtime.module.repository.internal.DefaultRepositoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryServiceFactory {
    public static final String MULE_REPOSITORY_FOLDER_PROPERTY = "mule.repository.folder";
    public static final String MULE_REMOTE_REPOSITORIES_PROPERTY = "mule.repository.repositories";
    private static final String REPOSITORY_FOLDER = "repository";
    private static final Logger logger = LoggerFactory.getLogger(RepositoryServiceFactory.class);

    public RepositoryService createRepositoryService() {
        File repositoryFolder = this.createRepositoryFolderIfDoesNotExists();
        List<RemoteRepository> remoteRepositories = this.collectRemoteRepositories();
        MavenClientProvider mavenClientProvider = MavenClientProvider.discoverProvider(RepositoryServiceFactory.class.getClassLoader());
        MavenClient mavenClient = mavenClientProvider.createMavenClient(this.getMavenConfiguration(repositoryFolder, remoteRepositories));
        return new DefaultRepositoryService(mavenClient);
    }

    private MavenConfiguration getMavenConfiguration(File localRepositoryFolder, List<RemoteRepository> remoteRepositories) {
        MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder = MavenConfiguration.newMavenConfigurationBuilder().localMavenRepositoryLocation(localRepositoryFolder);
        remoteRepositories.forEach(mavenConfigurationBuilder::remoteRepository);
        return mavenConfigurationBuilder.build();
    }

    private List<RemoteRepository> collectRemoteRepositories() {
        String[] remoteRepositoriesArray = System.getProperty(MULE_REMOTE_REPOSITORIES_PROPERTY, "").split(",");
        ArrayList<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>();
        for (String remoteRepository : remoteRepositoriesArray) {
            if (remoteRepository.trim().equals("")) continue;
            try {
                remoteRepositories.add(RemoteRepository.newRemoteRepositoryBuilder().id(remoteRepository).url(new URL(remoteRepository.trim())).build());
            }
            catch (MalformedURLException e) {
                throw new MuleRuntimeException(e);
            }
        }
        return remoteRepositories;
    }

    private File createRepositoryFolderIfDoesNotExists() {
        File repositoryFolder = this.resolveRepositoryFolder();
        this.createRepositoryFolder(repositoryFolder);
        return repositoryFolder;
    }

    private void createRepositoryFolder(File repositoryFolder) {
        if (!repositoryFolder.exists() && !repositoryFolder.mkdirs()) {
            throw new RuntimeException("Could not create dependencies folder with path " + repositoryFolder.getAbsolutePath());
        }
    }

    private File resolveRepositoryFolder() {
        String userDefinedDependenciesFolder = System.getProperty(MULE_REPOSITORY_FOLDER_PROPERTY);
        File repositoryFolder = userDefinedDependenciesFolder != null ? new File(userDefinedDependenciesFolder) : new File(MuleContainerUtils.getMuleLibDir(), REPOSITORY_FOLDER);
        if (logger.isDebugEnabled()) {
            logger.debug("Using dependencies folder " + repositoryFolder.getAbsolutePath());
        }
        return repositoryFolder;
    }
}

