/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.customization.impl.info;

import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.core.api.policy.PolicyChain;
import org.mule.runtime.tracer.api.span.info.InitialExportInfo;
import org.mule.runtime.tracer.api.span.info.InitialSpanInfo;
import org.mule.runtime.tracer.customization.api.InitialExportInfoProvider;
import org.mule.runtime.tracer.customization.impl.export.ExecutionInitialExportInfo;
import org.mule.runtime.tracer.customization.impl.export.TracingLevelExportInfo;
import org.mule.runtime.tracer.customization.impl.info.SpanInitialInfoUtils;
import org.mule.runtime.tracer.customization.impl.provider.DebugInitialExportInfoProvider;
import org.mule.runtime.tracer.customization.impl.provider.MonitoringInitialExportInfoProvider;
import org.mule.runtime.tracer.customization.impl.provider.OverviewInitialExportInfoProvider;
import org.mule.runtime.tracing.level.api.config.TracingLevel;
import org.mule.runtime.tracing.level.api.config.TracingLevelConfiguration;

public class ExecutionInitialSpanInfo
implements InitialSpanInfo {
    public static final String API_ID_ATTRIBUTE_KEY = "api.id";
    public static final String LOCATION_KEY = "location";
    public static final int INITIAL_ATTRIBUTES_BASE_COUNT = 1;
    public static final String EXECUTE_NEXT = "execute-next";
    public static final String FLOW = "flow";
    private final Component component;
    private final String overriddenName;
    private final String spanNameSuffix;
    private InitialExportInfo initialExportInfo;
    private String name;
    private final boolean isPolicySpan;
    private final boolean rootSpan;
    private final String location;
    private final String apiId;
    private int initialAttributesCount = 1;

    public ExecutionInitialSpanInfo(Component component, String apiId, String overriddenName, String spanNameSuffix, TracingLevelConfiguration tracingLevelConfiguration) {
        this.location = SpanInitialInfoUtils.getLocationAsString(component.getLocation());
        this.component = component;
        this.overriddenName = overriddenName;
        this.spanNameSuffix = spanNameSuffix;
        TracingLevelExportInfo tracingLevelExportInfo = this.getTracingLevelExportInfo(this.location, component, this.overriddenName, this.spanNameSuffix, tracingLevelConfiguration);
        this.initialExportInfo = ExecutionInitialSpanInfo.resolveInitialExporterInfo(tracingLevelExportInfo);
        this.isPolicySpan = this.isComponentOfName(component, EXECUTE_NEXT) || component instanceof PolicyChain || this.name.equals("mule:operation-execution");
        this.rootSpan = this.isComponentOfName(component, FLOW) || component instanceof PolicyChain;
        this.apiId = apiId;
        if (apiId != null) {
            this.initialAttributesCount = 2;
        }
    }

    public void reconfigureInitialSpanInfo(TracingLevelConfiguration tracingLevelConfiguration) {
        this.initialExportInfo = ExecutionInitialSpanInfo.resolveInitialExporterInfo(this.getTracingLevelExportInfo(this.location, this.component, this.overriddenName, this.spanNameSuffix, tracingLevelConfiguration));
    }

    private static ExecutionInitialExportInfo resolveInitialExporterInfo(TracingLevelExportInfo tracingLevelExportInfo) {
        return new ExecutionInitialExportInfo(tracingLevelExportInfo);
    }

    private TracingLevelExportInfo getTracingLevelExportInfo(String location, Component component, String overriddenName, String spanNameSuffix, TracingLevelConfiguration tracingLevelConfiguration) {
        TracingLevel tracingLevel = tracingLevelConfiguration.getTracingLevel();
        TracingLevel tracingLevelOverride = tracingLevelConfiguration.getTracingLevelOverride(location);
        TracingLevelExportInfo tracingLevelExportInfo = !tracingLevelOverride.equals((Object)tracingLevel) ? new TracingLevelExportInfo(this.resolveInitialExportInfoProvider(tracingLevelOverride), true) : new TracingLevelExportInfo(this.resolveInitialExportInfoProvider(tracingLevel), false);
        if (overriddenName == null) {
            this.name = SpanInitialInfoUtils.getSpanName(component.getIdentifier()) + StringUtils.defaultString((String)spanNameSuffix);
            tracingLevelExportInfo.setSpanIdentifier(component);
        } else {
            this.name = overriddenName;
            tracingLevelExportInfo.setSpanIdentifier(this.name);
        }
        return tracingLevelExportInfo;
    }

    private InitialExportInfoProvider resolveInitialExportInfoProvider(TracingLevel tracingLevel) {
        switch (tracingLevel) {
            case OVERVIEW: {
                return new OverviewInitialExportInfoProvider();
            }
            case DEBUG: {
                return new DebugInitialExportInfoProvider();
            }
        }
        return new MonitoringInitialExportInfoProvider();
    }

    @Override
    public void forEachAttribute(BiConsumer<String, String> biConsumer) {
        biConsumer.accept(LOCATION_KEY, this.location);
        if (this.apiId != null) {
            biConsumer.accept(API_ID_ATTRIBUTE_KEY, this.apiId);
        }
    }

    @Override
    public int getInitialAttributesCount() {
        return this.initialAttributesCount;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public InitialExportInfo getInitialExportInfo() {
        return this.initialExportInfo;
    }

    @Override
    public boolean isPolicySpan() {
        return this.isPolicySpan;
    }

    @Override
    public boolean isRootSpan() {
        return this.rootSpan;
    }

    private boolean isComponentOfName(Component component, String name) {
        return component.getIdentifier() != null && name.equals(component.getIdentifier().getName());
    }
}

