/*
 * Decompiled with CFR 0.152.
 */
package org.mule.mvel2.integration.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mule.mvel2.ParserConfiguration;
import org.mule.mvel2.UnresolveablePropertyException;
import org.mule.mvel2.integration.VariableResolver;
import org.mule.mvel2.integration.VariableResolverFactory;
import org.mule.mvel2.integration.impl.BaseVariableResolverFactory;
import org.mule.mvel2.integration.impl.MapVariableResolverFactory;
import org.mule.mvel2.integration.impl.SimpleValueResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassImportResolverFactory
extends BaseVariableResolverFactory {
    private Set<String> packageImports;
    private ClassLoader classLoader;
    private Map<String, Object> imports;
    private Map<String, Object> dynImports;

    public ClassImportResolverFactory(ParserConfiguration pCfg, VariableResolverFactory nextFactory, boolean compiled) {
        if (pCfg != null) {
            if (!compiled) {
                this.packageImports = pCfg.getPackageImports();
            }
            this.classLoader = pCfg.getClassLoader();
            this.imports = Collections.unmodifiableMap(pCfg.getImports());
        } else {
            this.classLoader = Thread.currentThread().getContextClassLoader();
        }
        this.nextFactory = nextFactory;
    }

    @Override
    public VariableResolver createVariable(String name, Object value) {
        if (this.nextFactory == null) {
            this.nextFactory = new MapVariableResolverFactory(new HashMap());
        }
        return this.nextFactory.createVariable(name, value);
    }

    public VariableResolver createVariable(String name, Object value, Class type) {
        if (this.nextFactory == null) {
            this.nextFactory = new MapVariableResolverFactory(new HashMap());
        }
        return this.nextFactory.createVariable(name, value);
    }

    public Class addClass(Class clazz) {
        if (this.dynImports == null) {
            this.dynImports = new HashMap<String, Object>();
        }
        this.dynImports.put(clazz.getSimpleName(), clazz);
        return clazz;
    }

    @Override
    public boolean isTarget(String name) {
        if (name == null) {
            return false;
        }
        return this.imports != null && this.imports.containsKey(name) || this.dynImports != null && this.dynImports.containsKey(name);
    }

    @Override
    public boolean isResolveable(String name) {
        if (name == null) {
            return false;
        }
        if (this.imports != null && this.imports.containsKey(name) || this.dynImports != null && this.dynImports.containsKey(name) || this.isNextResolveable(name)) {
            return true;
        }
        if (this.packageImports != null) {
            for (String s : this.packageImports) {
                try {
                    this.addClass(this.classLoader.loadClass(s + "." + name));
                    return true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                }
            }
        }
        return false;
    }

    @Override
    public VariableResolver getVariableResolver(String name) {
        if (this.isResolveable(name)) {
            if (this.imports != null && this.imports.containsKey(name)) {
                return new SimpleValueResolver(this.imports.get(name));
            }
            if (this.dynImports != null && this.dynImports.containsKey(name)) {
                return new SimpleValueResolver(this.dynImports.get(name));
            }
            if (this.nextFactory != null) {
                return this.nextFactory.getVariableResolver(name);
            }
        }
        throw new UnresolveablePropertyException("unable to resolve variable '" + name + "'");
    }

    public void clear() {
    }

    public Map<String, Object> getImportedClasses() {
        return this.imports;
    }

    public void addPackageImport(String packageName) {
        if (this.packageImports == null) {
            this.packageImports = new HashSet<String>();
        }
        this.packageImports.add(packageName);
    }

    @Override
    public Set<String> getKnownVariables() {
        return this.nextFactory == null ? new HashSet(0) : this.nextFactory.getKnownVariables();
    }
}

