/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.domain.entity;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.OptionalLong;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;

public final class ByteArrayHttpEntity
implements HttpEntity {
    private byte[] content;

    public ByteArrayHttpEntity(byte[] content) {
        Preconditions.checkNotNull(content, "HTTP entity content cannot be null.");
        this.content = content;
    }

    @Override
    public boolean isStreaming() {
        return false;
    }

    @Override
    public boolean isComposed() {
        return false;
    }

    @Override
    public InputStream getContent() {
        return new ByteArrayInputStream(this.content);
    }

    @Override
    public byte[] getBytes() {
        return this.content;
    }

    @Override
    public Collection<HttpPart> getParts() {
        return Collections.emptyList();
    }

    @Override
    public Optional<Long> getLength() {
        return Optional.of(Long.valueOf(this.content.length));
    }

    @Override
    public OptionalLong getBytesLength() {
        return OptionalLong.of(this.content.length);
    }
}

