/*
 * Decompiled with CFR 0.152.
 */
package org.mule.mvel2.integration.impl;

import java.util.Map;
import org.mule.mvel2.DataConversion;
import org.mule.mvel2.integration.VariableResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapVariableResolver
implements VariableResolver {
    private String name;
    private Class<?> knownType;
    private Map<String, Object> variableMap;

    public MapVariableResolver(Map<String, Object> variableMap, String name) {
        this.variableMap = variableMap;
        this.name = name;
    }

    public MapVariableResolver(Map<String, Object> variableMap, String name, Class knownType) {
        this.name = name;
        this.knownType = knownType;
        this.variableMap = variableMap;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setStaticType(Class knownType) {
        this.knownType = knownType;
    }

    public void setVariableMap(Map<String, Object> variableMap) {
        this.variableMap = variableMap;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class getType() {
        return this.knownType;
    }

    @Override
    public void setValue(Object value) {
        if (this.knownType != null && value != null && value.getClass() != this.knownType) {
            if (!DataConversion.canConvert(this.knownType, value.getClass())) {
                throw new RuntimeException("cannot assign " + value.getClass().getName() + " to type: " + this.knownType.getName());
            }
            try {
                value = DataConversion.convert(value, this.knownType);
            }
            catch (Exception e) {
                throw new RuntimeException("cannot convert value of " + value.getClass().getName() + " to: " + this.knownType.getName());
            }
        }
        this.variableMap.put(this.name, value);
    }

    @Override
    public Object getValue() {
        return this.variableMap.get(this.name);
    }

    @Override
    public int getFlags() {
        return 0;
    }
}

