/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.soap.api.message;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.soap.SoapAttachment;
import org.mule.runtime.soap.api.message.ImmutableSoapRequest;

public class SoapRequestBuilder {
    private InputStream content;
    private ImmutableMap.Builder<String, String> soapHeaders = ImmutableMap.builder();
    private ImmutableMap.Builder<String, String> transportHeaders = ImmutableMap.builder();
    private ImmutableMap.Builder<String, SoapAttachment> attachments = ImmutableMap.builder();
    private MediaType contentType = MediaType.APPLICATION_XML;
    private String operation;

    SoapRequestBuilder() {
    }

    public SoapRequestBuilder content(InputStream content) {
        this.content = content;
        return this;
    }

    public SoapRequestBuilder content(String content) {
        this.content = new ByteArrayInputStream(content.getBytes());
        return this;
    }

    public SoapRequestBuilder soapHeaders(Map<String, String> soapHeaders) {
        this.soapHeaders.putAll(soapHeaders);
        return this;
    }

    public SoapRequestBuilder transportHeader(String key, String value) {
        this.transportHeaders.put((Object)key, (Object)value);
        return this;
    }

    public SoapRequestBuilder transportHeaders(Map<String, String> headers) {
        this.transportHeaders.putAll(headers);
        return this;
    }

    public SoapRequestBuilder attachment(String name, SoapAttachment attachment) {
        this.attachments.put((Object)name, (Object)attachment);
        return this;
    }

    public SoapRequestBuilder attachments(Map<String, SoapAttachment> attachments) {
        this.attachments.putAll(attachments);
        return this;
    }

    public SoapRequestBuilder contentType(MediaType contentType) {
        this.contentType = contentType;
        return this;
    }

    public SoapRequestBuilder operation(String operation) {
        this.operation = operation;
        return this;
    }

    public ImmutableSoapRequest build() {
        Preconditions.checkNotNull(this.operation, "Missing executing operation");
        return new ImmutableSoapRequest(this.content, (Map<String, String>)this.soapHeaders.build(), (Map<String, String>)this.transportHeaders.build(), (Map<String, SoapAttachment>)this.attachments.build(), this.contentType, this.operation);
    }
}

