/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.artifact;

import java.io.File;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.StampedLock;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.globalconfig.api.GlobalConfigLoader;
import org.mule.runtime.globalconfig.api.maven.MavenClientFactory;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfiguration;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfigurationLoader;
import org.mule.runtime.module.artifact.api.descriptor.InvalidDescriptorLoaderException;
import org.mule.runtime.module.deployment.impl.internal.application.DeployableMavenClassLoaderConfigurationLoader;
import org.mule.runtime.module.deployment.impl.internal.plugin.PluginMavenClassLoaderConfigurationLoader;
import org.mule.runtime.module.service.api.artifact.ServiceClassLoaderFactoryProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenClassLoaderConfigurationLoader
implements ClassLoaderConfigurationLoader,
Disposable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(MavenClassLoaderConfigurationLoader.class);
    private DeployableMavenClassLoaderConfigurationLoader deployableMavenClassLoaderConfigurationLoader;
    private PluginMavenClassLoaderConfigurationLoader pluginMavenClassLoaderConfigurationLoader;
    private ClassLoaderConfigurationLoader libFolderClassLoaderConfigurationLoader;
    private volatile MavenConfiguration mavenRuntimeConfig;
    private volatile MavenClient mavenClient;
    private final StampedLock lock = new StampedLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        long stamp = this.lock.readLock();
        try {
            MavenConfiguration updatedMavenConfiguration = GlobalConfigLoader.getMavenConfig();
            if (!updatedMavenConfiguration.equals(this.mavenRuntimeConfig)) {
                long writeStamp = this.lock.tryConvertToWriteLock(stamp);
                if (writeStamp == 0L) {
                    this.lock.unlockRead(stamp);
                    stamp = this.lock.writeLock();
                } else {
                    stamp = writeStamp;
                }
                if (!updatedMavenConfiguration.equals(this.mavenRuntimeConfig)) {
                    this.mavenRuntimeConfig = updatedMavenConfiguration;
                    this.createClassLoaderConfigurationLoaders();
                }
            }
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    private void createClassLoaderConfigurationLoaders() {
        this.closeMavenClient();
        this.mavenClient = MavenClientFactory.createMavenClient(this.mavenRuntimeConfig);
        this.deployableMavenClassLoaderConfigurationLoader = new DeployableMavenClassLoaderConfigurationLoader(Optional.ofNullable(this.mavenClient));
        this.pluginMavenClassLoaderConfigurationLoader = new PluginMavenClassLoaderConfigurationLoader(Optional.ofNullable(this.mavenClient));
        this.libFolderClassLoaderConfigurationLoader = ServiceClassLoaderFactoryProvider.serviceClassLoaderConfigurationLoader();
    }

    @Override
    public String getId() {
        return "mule";
    }

    @Override
    public ClassLoaderConfiguration load(File artifactFile, Map<String, Object> attributes, ArtifactType artifactType) throws InvalidDescriptorLoaderException {
        this.refresh();
        if (this.deployableMavenClassLoaderConfigurationLoader.supportsArtifactType(artifactType)) {
            return this.deployableMavenClassLoaderConfigurationLoader.load(artifactFile, (Map)attributes, artifactType);
        }
        if (this.pluginMavenClassLoaderConfigurationLoader.supportsArtifactType(artifactType)) {
            return this.pluginMavenClassLoaderConfigurationLoader.load(artifactFile, (Map)attributes, artifactType);
        }
        if (this.libFolderClassLoaderConfigurationLoader.supportsArtifactType(artifactType)) {
            return (ClassLoaderConfiguration)this.libFolderClassLoaderConfigurationLoader.load(artifactFile, attributes, artifactType);
        }
        throw new IllegalStateException(String.format("Artifact type %s not supported", new Object[]{artifactType}));
    }

    @Override
    public boolean supportsArtifactType(ArtifactType artifactType) {
        this.refresh();
        return this.deployableMavenClassLoaderConfigurationLoader.supportsArtifactType(artifactType) || this.pluginMavenClassLoaderConfigurationLoader.supportsArtifactType(artifactType) || this.libFolderClassLoaderConfigurationLoader.supportsArtifactType(artifactType);
    }

    @Override
    public void dispose() {
        this.closeMavenClient();
    }

    private void closeMavenClient() {
        if (this.mavenClient != null) {
            try {
                this.mavenClient.close();
            }
            catch (Exception e) {
                LOGGER.error("Error while disposing 'mavenClient'", (Throwable)e);
            }
        }
    }
}

