/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.raml.internal.fragments.handler;

import java.util.Arrays;
import java.util.List;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.raml.internal.fragments.handler.AnyTypeDeclarationHandler;
import org.mule.metadata.raml.internal.fragments.handler.ArrayTypeDeclarationHandler;
import org.mule.metadata.raml.internal.fragments.handler.BooleanTypeDeclarationHandler;
import org.mule.metadata.raml.internal.fragments.handler.DateOnlyTypeDeclarationHandler;
import org.mule.metadata.raml.internal.fragments.handler.DateTimeOnlyTypeDeclarationHandler;
import org.mule.metadata.raml.internal.fragments.handler.DateTimeTypeDeclarationHandler;
import org.mule.metadata.raml.internal.fragments.handler.ExternalTypeDeclarationHandler;
import org.mule.metadata.raml.internal.fragments.handler.FileTypeDeclarationHandler;
import org.mule.metadata.raml.internal.fragments.handler.IntegerTypeDeclarationHandler;
import org.mule.metadata.raml.internal.fragments.handler.JSONTypeDeclarationHandler;
import org.mule.metadata.raml.internal.fragments.handler.NilTypeDeclarationHandler;
import org.mule.metadata.raml.internal.fragments.handler.NumberTypeDeclarationHandler;
import org.mule.metadata.raml.internal.fragments.handler.ObjectTypeDeclarationHandler;
import org.mule.metadata.raml.internal.fragments.handler.ParsingContext;
import org.mule.metadata.raml.internal.fragments.handler.StringTypeDeclarationHandler;
import org.mule.metadata.raml.internal.fragments.handler.TimeOnlyTypeDeclarationHandler;
import org.mule.metadata.raml.internal.fragments.handler.TypeDeclarationHandler;
import org.mule.metadata.raml.internal.fragments.handler.UnionTypeDeclarationHandler;
import org.mule.metadata.raml.internal.fragments.handler.XMLTypeDeclarationHandler;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class TypeDeclarationHandlerManager {
    private final MetadataFormat metadataFormat;
    private List<? extends TypeDeclarationHandler> typeDeclarationHandlers = Arrays.asList(new NilTypeDeclarationHandler(), new BooleanTypeDeclarationHandler(), new StringTypeDeclarationHandler(), new IntegerTypeDeclarationHandler(), new NumberTypeDeclarationHandler(), new DateTimeTypeDeclarationHandler(), new DateTimeOnlyTypeDeclarationHandler(), new DateOnlyTypeDeclarationHandler(), new TimeOnlyTypeDeclarationHandler(), new FileTypeDeclarationHandler(), new ArrayTypeDeclarationHandler(), new ObjectTypeDeclarationHandler(), new UnionTypeDeclarationHandler(), new XMLTypeDeclarationHandler(), new JSONTypeDeclarationHandler(), new ExternalTypeDeclarationHandler(), new AnyTypeDeclarationHandler());

    public TypeDeclarationHandlerManager(MetadataFormat metadataFormat) {
        this.metadataFormat = metadataFormat;
    }

    public TypeBuilder<?> handle(TypeDeclaration typeDeclaration, ParsingContext parsingContext) {
        if (typeDeclaration == null) {
            throw new IllegalArgumentException("Unhandled null type declaration");
        }
        if (parsingContext.isTypeBuilderPresent(typeDeclaration)) {
            return parsingContext.getTypeBuilder(typeDeclaration).get();
        }
        BaseTypeBuilder root = BaseTypeBuilder.create(this.metadataFormat);
        for (TypeDeclarationHandler typeDeclarationHandler : this.typeDeclarationHandlers) {
            if (!typeDeclarationHandler.handles(typeDeclaration)) continue;
            return typeDeclarationHandler.handle(typeDeclaration, root, this, parsingContext);
        }
        throw new IllegalArgumentException(String.format("Unhandled type declaration %s", typeDeclaration.type()));
    }
}

