/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.message.api;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.builder.AbstractBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.BasicTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.WithAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.message.api.DefaultMessageMetadataType;
import org.mule.metadata.message.api.MessageMetadataType;

public class MessageMetadataTypeBuilder
extends AbstractBuilder<MessageMetadataType>
implements WithAnnotation<MessageMetadataTypeBuilder> {
    private Optional<TypeBuilder<? extends MetadataType>> payloadType;
    protected final Map<Class<? extends TypeAnnotation>, TypeAnnotation> payloadAnnotations;
    private Optional<TypeBuilder<? extends MetadataType>> attributesType;
    protected final Map<Class<? extends TypeAnnotation>, TypeAnnotation> attributesAnnotations;

    public MessageMetadataTypeBuilder() {
        super(MetadataFormat.JAVA);
        this.addExtension(new TypeIdAnnotation("org.mule.runtime.api.message.Message"));
        this.payloadType = Optional.empty();
        this.payloadAnnotations = new LinkedHashMap<Class<? extends TypeAnnotation>, TypeAnnotation>();
        this.attributesType = Optional.empty();
        this.attributesAnnotations = new LinkedHashMap<Class<? extends TypeAnnotation>, TypeAnnotation>();
    }

    public BaseTypeBuilder payload() {
        BaseTypeBuilder baseTypeBuilder = BaseTypeBuilder.create(MetadataFormat.JAVA);
        this.payloadType = Optional.of(baseTypeBuilder);
        return baseTypeBuilder;
    }

    public MessageMetadataTypeBuilder payload(MetadataType payloadType) {
        this.payloadType = Optional.of(new BasicTypeBuilder<MetadataType>(payloadType));
        return this;
    }

    public BaseTypeBuilder attributes() {
        BaseTypeBuilder baseTypeBuilder = BaseTypeBuilder.create(MetadataFormat.JAVA);
        this.attributesType = Optional.of(baseTypeBuilder);
        return baseTypeBuilder;
    }

    public MessageMetadataTypeBuilder attributes(MetadataType payloadType) {
        this.attributesType = Optional.of(new BasicTypeBuilder<MetadataType>(payloadType));
        return this;
    }

    private void internalAddExtension(Map<Class<? extends TypeAnnotation>, TypeAnnotation> annotations, TypeAnnotation extension, String part) {
        if (annotations.containsKey(extension.getClass())) {
            throw new IllegalArgumentException(String.format("an annotation of type '%s' is already defined on %s", extension.getClass(), part));
        }
        annotations.put(extension.getClass(), extension);
    }

    public MessageMetadataTypeBuilder withPayloadAnnotation(TypeAnnotation extension) {
        this.internalAddExtension(this.payloadAnnotations, extension, "payload");
        return this;
    }

    public MessageMetadataTypeBuilder withAttributesAnnotation(TypeAnnotation extension) {
        this.internalAddExtension(this.attributesAnnotations, extension, "attributes");
        return this;
    }

    @Override
    public MessageMetadataType build() {
        return new DefaultMessageMetadataType(this.payloadType.map(b -> b.build()), o -> this.payloadAnnotations.forEach((aClass, typeAnnotation) -> o.with((TypeAnnotation)typeAnnotation)), this.attributesType.map(b -> b.build()), o -> this.attributesAnnotations.forEach((aClass, typeAnnotation) -> o.with((TypeAnnotation)typeAnnotation)), this.annotations);
    }

    public static MessageMetadataTypeBuilder fromObjectType(ObjectType messageType) {
        MessageMetadataTypeBuilder builder = new MessageMetadataTypeBuilder();
        messageType.getFieldByName("payload").ifPresent(objectFieldType -> {
            builder.payload(objectFieldType.getValue());
            objectFieldType.getAnnotations().forEach(builder::withPayloadAnnotation);
        });
        messageType.getFieldByName("attributes").ifPresent(objectFieldType -> {
            builder.attributes(objectFieldType.getValue());
            objectFieldType.getAnnotations().forEach(builder::withAttributesAnnotation);
        });
        return builder;
    }

    @Override
    public MessageMetadataTypeBuilder with(TypeAnnotation typeAnnotation) {
        this.addExtension(typeAnnotation);
        return this;
    }
}

