/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization.json.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Optional;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.ast.api.error.ErrorTypeRepositoryProvider;
import org.mule.runtime.ast.internal.error.ErrorTypeBuilder;

public class ErrorTypeJsonDeserializer
implements JsonDeserializer<ErrorType> {
    private final ErrorTypeRepository coreErrorTypeRepo = ErrorTypeRepositoryProvider.getCoreErrorTypeRepo();

    public ErrorType deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject errorTypeJsonObject = jsonElement.getAsJsonObject();
        return this.getErrorType(type, jsonDeserializationContext, errorTypeJsonObject.get("identifier").getAsString(), errorTypeJsonObject.get("namespace").getAsString(), errorTypeJsonObject.get("parentErrorType"));
    }

    private ErrorType getErrorType(Type type, JsonDeserializationContext jsonDeserializationContext, String identifier, String namespace, JsonElement parentErrorTypeJsonElement) {
        Optional<ErrorType> errorTypeOptional = this.coreErrorTypeRepo.lookupErrorType(ComponentIdentifier.builder().name(identifier).namespace(namespace).build());
        return errorTypeOptional.orElseGet(() -> this.buildErrorType(type, jsonDeserializationContext, identifier, namespace, parentErrorTypeJsonElement));
    }

    private ErrorType buildErrorType(Type type, JsonDeserializationContext jsonDeserializationContext, String identifier, String namespace, JsonElement parentErrorTypeJsonElement) {
        if (!this.isOrphan(identifier, namespace)) {
            return this.buildErrorTypeWithParent(type, jsonDeserializationContext, identifier, namespace, parentErrorTypeJsonElement);
        }
        return ErrorTypeBuilder.builder().identifier(identifier).namespace(namespace).build();
    }

    private ErrorType buildErrorTypeWithParent(Type type, JsonDeserializationContext jsonDeserializationContext, String identifier, String namespace, JsonElement parentErrorTypeJsonElement) {
        ErrorType parentErrorType = this.deserialize(parentErrorTypeJsonElement, type, jsonDeserializationContext);
        return ErrorTypeBuilder.builder().identifier(identifier).namespace(namespace).parentErrorType(parentErrorType).build();
    }

    private boolean isOrphan(String identifier, String namespace) {
        return (identifier.equals(ErrorTypeBuilder.ANY_IDENTIFIER) || identifier.equals(ErrorTypeBuilder.CRITICAL_IDENTIFIER)) && namespace.equals(ErrorTypeBuilder.CORE_NAMESPACE_NAME);
    }
}

