/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;

public class AllComponentsBelongToSomeExtensionModel
implements Validation {
    private final boolean shouldBeError;

    public AllComponentsBelongToSomeExtensionModel(boolean isCompatibilityPluginInstalled) {
        this.shouldBeError = !isCompatibilityPluginInstalled;
    }

    @Override
    public String getName() {
        return "All components belong to some extension model";
    }

    @Override
    public String getDescription() {
        return "All components belong to some extension model";
    }

    @Override
    public Validation.Level getLevel() {
        return this.shouldBeError ? Validation.Level.ERROR : Validation.Level.WARN;
    }

    @Override
    public Predicate<List<ComponentAst>> applicable() {
        return c -> true;
    }

    @Override
    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        if (component.getExtensionModel() == null) {
            return Optional.of(ValidationResultItem.create(component, (Validation)this, String.format("The component '%s' doesn't belong to any extension model", component.getIdentifier())));
        }
        return Optional.empty();
    }
}

