/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.factories;

import java.util.List;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.meta.NameableObject;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.processor.AsyncDelegateMessageProcessor;
import org.mule.runtime.core.privileged.processor.MessageProcessorBuilder;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.springframework.beans.factory.FactoryBean;

public class AsyncMessageProcessorsFactoryBean
extends AbstractComponent
implements FactoryBean<Processor>,
MuleContextAware,
NameableObject {
    protected MuleContext muleContext;
    protected List messageProcessors;
    protected String name;
    protected Integer maxConcurrency;

    public Class getObjectType() {
        return Processor.class;
    }

    public void setMessageProcessors(List messageProcessors) {
        this.messageProcessors = messageProcessors;
    }

    public AsyncDelegateMessageProcessor getObject() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.setName("'async' child chain");
        for (Object processor : this.messageProcessors) {
            if (processor instanceof Processor) {
                builder.chain((Processor)processor);
                continue;
            }
            if (processor instanceof MessageProcessorBuilder) {
                builder.chain((MessageProcessorBuilder)processor);
                continue;
            }
            throw new IllegalArgumentException("MessageProcessorBuilder should only have MessageProcessor's or MessageProcessorBuilder's configured");
        }
        AsyncDelegateMessageProcessor delegate = new AsyncDelegateMessageProcessor(builder, this.name);
        delegate.setAnnotations(this.getAnnotations());
        if (this.getMaxConcurrency() != null) {
            delegate.setMaxConcurrency(this.getMaxConcurrency());
        }
        return delegate;
    }

    public boolean isSingleton() {
        return true;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public Integer getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public void setMaxConcurrency(Integer maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
    }
}

