/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.profiling.threading;

import java.util.Objects;
import org.mule.runtime.api.profiling.threading.ThreadSnapshot;

public final class DefaultThreadSnapshot
implements ThreadSnapshot {
    private final Long blockedTime;
    private final Long waitedTime;
    private final Long cpuTime;

    private DefaultThreadSnapshot(Long blockedTime, Long waitedTime, Long cpuTime) {
        this.blockedTime = blockedTime;
        this.waitedTime = waitedTime;
        this.cpuTime = cpuTime;
    }

    @Override
    public Long getBlockedTime() {
        return this.blockedTime;
    }

    @Override
    public Long getWaitedTime() {
        return this.waitedTime;
    }

    @Override
    public Long getCpuTime() {
        return this.cpuTime;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Long blockedTime = null;
        private Long waitedTime = null;
        private Long cpuTime = null;

        public DefaultThreadSnapshot build() {
            Objects.requireNonNull(this.blockedTime);
            Objects.requireNonNull(this.waitedTime);
            Objects.requireNonNull(this.cpuTime);
            return new DefaultThreadSnapshot(this.blockedTime, this.waitedTime, this.cpuTime);
        }

        Builder withBlockedTime(Long pBlockedTime) {
            this.blockedTime = pBlockedTime;
            return this;
        }

        Builder withWaitedTime(Long pWaitedTime) {
            this.waitedTime = pWaitedTime;
            return this;
        }

        Builder withCPUTime(Long pCpuTime) {
            this.cpuTime = pCpuTime;
            return this;
        }
    }
}

