/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.log4j.internal;

import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.message.MessageFactory;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.runtime.module.log4j.internal.DispatchingLogger;
import org.mule.runtime.module.log4j.internal.LoggerContextConfigurer;

class MuleLoggerContext
extends LoggerContext {
    private final LoggerContextConfigurer loggerContextConfigurer = new LoggerContextConfigurer();
    private final URI configFile;
    private final boolean standalone;
    private final boolean logSeparationEnabled;
    private ContextSelector contextSelector;
    private final boolean artifactClassloader;
    private final boolean applicationClassloader;
    private final String artifactName;
    private final int ownerClassLoaderHash;
    private DeployableArtifactDescriptor artifactDescriptor;

    MuleLoggerContext(String name, ContextSelector contextSelector, boolean standalone, boolean logSeparationEnabled) {
        this(name, null, null, contextSelector, standalone, logSeparationEnabled);
    }

    MuleLoggerContext(String name, URI configLocn, ClassLoader ownerClassLoader, ContextSelector contextSelector, boolean standalone, boolean logSeparationEnabled) {
        super(name, null, configLocn);
        int n;
        this.configFile = configLocn;
        this.contextSelector = contextSelector;
        this.standalone = standalone;
        this.logSeparationEnabled = logSeparationEnabled;
        if (ownerClassLoader != null) {
            n = ownerClassLoader.hashCode();
        } else {
            ((Object)((Object)this)).getClass().getClassLoader();
            n = this.ownerClassLoaderHash = ClassLoader.getSystemClassLoader().hashCode();
        }
        if (ownerClassLoader instanceof ArtifactClassLoader) {
            this.artifactClassloader = true;
            this.artifactName = this.getArtifactName((ArtifactClassLoader)((Object)ownerClassLoader));
            this.artifactDescriptor = this.getArtifactDescriptor((ArtifactClassLoader)((Object)ownerClassLoader));
            this.applicationClassloader = ownerClassLoader instanceof RegionClassLoader && ((RegionClassLoader)ownerClassLoader).getOwnerClassLoader().getArtifactDescriptor() instanceof ApplicationDescriptor;
        } else {
            this.artifactClassloader = false;
            this.applicationClassloader = false;
            this.artifactName = null;
        }
    }

    private DeployableArtifactDescriptor getArtifactDescriptor(ArtifactClassLoader ownerClassLoader) {
        if (!(ownerClassLoader.getArtifactDescriptor() instanceof DeployableArtifactDescriptor)) {
            throw new IllegalArgumentException("Artifact should be a deployable, i.e. an application or domain");
        }
        return (DeployableArtifactDescriptor)ownerClassLoader.getArtifactDescriptor();
    }

    private String getArtifactName(ArtifactClassLoader ownerClassLoader) {
        return ((ArtifactDescriptor)ownerClassLoader.getArtifactDescriptor()).getName();
    }

    public void reconfigure() {
        this.loggerContextConfigurer.configure(this);
        if (this.loggerContextConfigurer.shouldConfigureContext(this)) {
            super.reconfigure();
        }
    }

    public void updateLoggers(Configuration config) {
        this.loggerContextConfigurer.update(this);
        super.updateLoggers(config);
    }

    protected Logger newInstance(LoggerContext ctx, String name, MessageFactory messageFactory) {
        Logger logger = super.newInstance(ctx, name, messageFactory);
        if (this.artifactClassloader || this.applicationClassloader || !this.logSeparationEnabled) {
            return logger;
        }
        return new DispatchingLogger(logger, this.ownerClassLoaderHash, this, this.contextSelector, messageFactory){

            public String getName() {
                return this.name;
            }
        };
    }

    protected URI getConfigFile() {
        return this.configFile;
    }

    protected boolean isStandalone() {
        return this.standalone;
    }

    protected boolean isArtifactClassloader() {
        return this.artifactClassloader;
    }

    protected boolean isApplicationClassloader() {
        return this.applicationClassloader;
    }

    protected DeployableArtifactDescriptor getArtifactDescriptor() {
        return this.artifactDescriptor;
    }

    protected String getArtifactName() {
        return this.artifactName;
    }

    public void stop() {
        super.stop();
        this.artifactDescriptor = null;
        this.contextSelector = null;
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        boolean result = super.stop(timeout, timeUnit);
        this.artifactDescriptor = null;
        this.contextSelector = null;
        return result;
    }
}

