/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.api.artifact;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import org.mule.api.annotation.jpms.RequiredOpens;
import org.mule.api.annotation.jpms.ServiceModule;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.container.api.MuleContainerClassLoaderWrapper;
import org.mule.runtime.jpms.api.JpmsUtils;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.ModuleLayerInformationSupplier;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.service.api.artifact.ServiceClassLoaderFactory;
import org.mule.runtime.module.service.api.artifact.ServiceDescriptor;
import org.mule.runtime.module.service.api.artifact.ServiceModuleLayerFactory;
import org.mule.runtime.module.service.internal.artifact.ModuleLayerGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceModuleLayerFactory
extends ServiceClassLoaderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceModuleLayerFactory.class);
    private static final String CONTAINER_LAYER_NAME = "Mule Container Module Layer";
    private static final Set<String> MULE_SERVICE_MODULE_NAME_PREFIXES = new HashSet<String>(Arrays.asList("org.mule.service.", "com.mulesoft.mule.service."));
    private Optional<ModuleLayer> parentLayer = Optional.ofNullable(ServiceModuleLayerFactory.class.getModule().getLayer());

    ServiceModuleLayerFactory() {
    }

    @Override
    @Deprecated
    public ArtifactClassLoader create(String artifactId, ServiceDescriptor descriptor, ClassLoader parent, ClassLoaderLookupPolicy lookupPolicy) {
        URL[] classLoaderConfigurationUrls = descriptor.getClassLoaderConfiguration().getUrls();
        LOGGER.debug(" >> Creating ModuleLayer for service: '" + artifactId + "'...");
        ModuleLayer artifactLayer = JpmsUtils.createModuleLayer((URL[])classLoaderConfigurationUrls, (ClassLoader)parent, (Optional)this.parentLayer, (boolean)true, (boolean)true);
        Class serviceModuleAnnotationClass = this.getServiceModuleAnnotationClass(parent);
        Module serviceModule = artifactLayer.modules().stream().filter(module -> module.isAnnotationPresent(serviceModuleAnnotationClass)).findAny().orElseThrow(() -> new NoSuchElementException("No module annotated with 'ServiceModule' for '" + artifactId + "' in " + descriptor.getBundleDescriptor().getArtifactFileName()));
        String serviceModuleName = serviceModule.getName();
        if (MULE_SERVICE_MODULE_NAME_PREFIXES.stream().anyMatch(serviceModuleName::startsWith)) {
            this.propagateOpensToService(parent, artifactLayer, serviceModuleAnnotationClass, serviceModule, serviceModuleName);
        }
        MuleServiceClassLoader serviceClassLoader = new MuleServiceClassLoader(artifactId, (ArtifactDescriptor)descriptor, new URL[0], artifactLayer.findLoader(serviceModuleName), lookupPolicy);
        ModuleLayerGraph.setModuleLayerId((ModuleLayer)artifactLayer, (String)artifactId);
        artifactLayer.parents().stream().filter(parentLayer -> !parentLayer.equals(ModuleLayer.boot())).findFirst().ifPresent(parentLayer -> ModuleLayerGraph.setModuleLayerId((ModuleLayer)parentLayer, (String)CONTAINER_LAYER_NAME));
        ModuleLayerGraph graph = new ModuleLayerGraph(artifactLayer);
        serviceClassLoader.setModuleLayerInformationSupplier((ModuleLayerInformationSupplier)graph);
        if (parent instanceof ArtifactClassLoader) {
            ((ArtifactClassLoader)((Object)parent)).setModuleLayerInformationSupplier((ModuleLayerInformationSupplier)graph);
        }
        return serviceClassLoader;
    }

    private Class<? extends Annotation> getServiceModuleAnnotationClass(ClassLoader parent) {
        try {
            return parent.loadClass(ServiceModule.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new MuleRuntimeException(e);
        }
    }

    private void propagateOpensToService(ClassLoader parent, ModuleLayer artifactLayer, Class<? extends Annotation> serviceModuleAnnotationClass, Module serviceModule, String serviceModuleName) {
        try {
            Object[] requiredOpensAll;
            Class<?> requiredOpensAnnotationClass = parent.loadClass(RequiredOpens.class.getName());
            Annotation serviceModuleAnnotation = serviceModule.getAnnotation(serviceModuleAnnotationClass);
            for (Object requiredOpens : requiredOpensAll = (Object[])serviceModuleAnnotationClass.getMethod("requiredOpens", new Class[0]).invoke((Object)serviceModuleAnnotation, new Object[0])) {
                String moduleName = (String)requiredOpensAnnotationClass.getMethod("moduleName", new Class[0]).invoke(requiredOpens, new Object[0]);
                String[] packageNames = (String[])requiredOpensAnnotationClass.getMethod("packageNames", new Class[0]).invoke(requiredOpens, new Object[0]);
                JpmsUtils.openToModule((ModuleLayer)artifactLayer, (String)serviceModuleName, (String)moduleName, Arrays.asList(packageNames));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new MuleRuntimeException(e);
        }
    }

    @Override
    public ArtifactClassLoader create(String artifactId, ServiceDescriptor descriptor, MuleContainerClassLoaderWrapper containerClassLoader) {
        return this.create(artifactId, descriptor, containerClassLoader.getContainerClassLoader().getClassLoader(), containerClassLoader.getContainerClassLoaderLookupPolicy());
    }

    @Override
    public void setParentLayerFrom(Class clazz) {
        this.parentLayer = Optional.ofNullable(clazz.getModule().getLayer());
    }
}

