/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.troubleshooting.internal.operations;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.context.notification.FlowStackElement;
import org.mule.runtime.core.api.event.EventContextService;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.troubleshooting.api.ArgumentDefinition;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperation;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperationCallback;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperationDefinition;
import org.mule.runtime.module.troubleshooting.internal.DefaultArgumentDefinition;
import org.mule.runtime.module.troubleshooting.internal.DefaultTroubleshootingOperationDefinition;

public class EventDumpOperation
implements TroubleshootingOperation {
    public static final String EVENT_DUMP_OPERATION_NAME = "events";
    public static final String EVENT_DUMP_OPERATION_DESCRIPTION = "Collects an EventDump of currently active events";
    public static final String APPLICATION_ARGUMENT_NAME = "application";
    public static final String APPLICATION_ARGUMENT_DESCRIPTION = "Application to collect the event dump from";
    private static final TroubleshootingOperationDefinition definition = EventDumpOperation.createOperationDefinition();
    private final DeploymentService deploymentService;

    public EventDumpOperation(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    @Override
    public TroubleshootingOperationDefinition getDefinition() {
        return definition;
    }

    @Override
    public TroubleshootingOperationCallback getCallback() {
        return (arguments, writer) -> {
            String applicationName = (String)arguments.get(APPLICATION_ARGUMENT_NAME);
            if (applicationName == null) {
                this.writeFlowStacksForAllApplications(writer);
            } else {
                Application application = this.deploymentService.findApplication(applicationName);
                EventDumpOperation.writeFlowStackEntries(application, writer);
            }
        };
    }

    private static void writeFlowStacksFor(Application application, Writer writer) throws IOException {
        String appsTitle = "Active Events for application '" + application.getArtifactName() + "'";
        writer.write(appsTitle + System.lineSeparator());
        writer.write(StringUtils.leftPad((String)"", (int)appsTitle.length(), (String)"-") + System.lineSeparator());
        writer.write(System.lineSeparator());
        EventDumpOperation.writeFlowStackEntries(application, writer);
    }

    private void writeFlowStacksForAllApplications(Writer writer) throws IOException {
        for (Application application : this.deploymentService.getApplications()) {
            EventDumpOperation.writeFlowStacksFor(application, writer);
        }
    }

    private static void writeFlowStackEntries(Application application, Writer writer) throws IOException {
        EventContextService eventContextService = application.getArtifactContext().getRegistry().lookupByName("_muleEventContextService").map(EventContextService.class::cast).orElseThrow(() -> new IllegalArgumentException(String.format("Could not get EventContextService for application %s.", application.getArtifactName())));
        List<EventContextService.FlowStackEntry> currentlyActiveFlowStacks = eventContextService.getCurrentlyActiveFlowStacks();
        Collection<NestedEventsNode> roots = EventDumpOperation.hierarchicalEvents(currentlyActiveFlowStacks);
        writer.write(String.format("Total Event Contexts: %6d%nTotal Root Contexts:  %6d%n%n", currentlyActiveFlowStacks.size(), roots.size()));
        for (NestedEventsNode rootFlowStackNode : roots) {
            if (rootFlowStackNode.getDirectChidren().isEmpty()) {
                writer.write(EventDumpOperation.formatFlowStack(rootFlowStackNode.getFlowStack()));
                writer.write(System.lineSeparator());
                continue;
            }
            writer.write(System.lineSeparator());
            writer.write(String.format("\"%s\" hierarchy%n%n", rootFlowStackNode.getEventId()));
            EventDumpOperation.writeHierarchy(writer, rootFlowStackNode, 0);
        }
    }

    private static Collection<NestedEventsNode> hierarchicalEvents(List<EventContextService.FlowStackEntry> currentlyActiveFlowStacks) {
        TreeMap<String, NestedEventsNode> nodesById = new TreeMap<String, NestedEventsNode>();
        for (EventContextService.FlowStackEntry fs : currentlyActiveFlowStacks) {
            Map.Entry node = new NestedEventsNode(fs.getEventId(), fs);
            nodesById.put(fs.getEventId(), (NestedEventsNode)((Object)node));
        }
        TreeMap<String, NestedEventsNode> roots = new TreeMap<String, NestedEventsNode>();
        for (Map.Entry node : nodesById.entrySet()) {
            String parentEventId = ((NestedEventsNode)node.getValue()).getFlowStack().getParentEventId();
            if (parentEventId != null) {
                ((NestedEventsNode)nodesById.get(parentEventId)).addDirectChild((NestedEventsNode)node.getValue());
                continue;
            }
            roots.put((String)node.getKey(), (NestedEventsNode)node.getValue());
        }
        return roots.values();
    }

    private static void writeHierarchy(Writer writer, NestedEventsNode node, int identIndex, FlowCallStack parentStack) throws IOException {
        FlowCallStack currentStack = node.getFlowStack().getFlowCallStack();
        for (NestedEventsNode childNode : node.getDirectChidren()) {
            EventDumpOperation.writeHierarchy(writer, childNode, identIndex + 4, currentStack);
        }
        writer.write(Arrays.stream(StringUtils.split((String)EventDumpOperation.formatFlowStack(node.getFlowStack(), parentStack), (String)System.lineSeparator())).map(s -> StringUtils.repeat((String)" ", (int)identIndex) + s).collect(Collectors.joining(System.lineSeparator(), "", System.lineSeparator())));
        writer.write(System.lineSeparator());
    }

    private static void writeHierarchy(Writer writer, NestedEventsNode node, int identIndex) throws IOException {
        EventDumpOperation.writeHierarchy(writer, node, identIndex, null);
    }

    private static String formatFlowStack(EventContextService.FlowStackEntry fs) {
        return EventDumpOperation.formatFlowStack(fs, null);
    }

    private static String formatFlowStack(EventContextService.FlowStackEntry fs, FlowCallStack parentStack) {
        FlowCallStack currentStack = fs.getFlowCallStack();
        String stackString = parentStack != null ? EventDumpOperation.flowCallStackStringUnique(currentStack, parentStack) : EventDumpOperation.flowCallStackString(currentStack);
        return String.format("\"%s\", running for: %s, state: %s%n%s", fs.getEventId(), DurationFormatUtils.formatDuration((long)fs.getExecutingTime().toMillis(), (String)"mm:ss.SSS"), fs.getState().name(), Arrays.stream(StringUtils.split((String)stackString, (String)System.lineSeparator())).map(s -> StringUtils.repeat((String)" ", (int)4) + s).collect(Collectors.joining(System.lineSeparator(), "", System.lineSeparator())));
    }

    private static String flowCallStackString(FlowCallStack flowCallStack) {
        return EventDumpOperation.flowCallStackString(flowCallStack.getElements());
    }

    private static String flowCallStackString(List<FlowStackElement> flowStackElements) {
        StringBuilder stackString = new StringBuilder(256);
        int i = 0;
        for (FlowStackElement flowStackElement : flowStackElements) {
            stackString.append("at ").append(flowStackElement.toStringEventDumpFormat());
            if (++i == flowStackElements.size()) continue;
            stackString.append(System.lineSeparator());
        }
        return stackString.toString();
    }

    private static String flowCallStackStringUnique(FlowCallStack childStack, FlowCallStack parentStack) {
        List<FlowStackElement> childElements = childStack.getElements();
        List<FlowStackElement> parentElements = parentStack.getElements();
        if (childElements.isEmpty()) {
            return "";
        }
        if (parentElements.isEmpty()) {
            return EventDumpOperation.flowCallStackString(childStack);
        }
        int uniquePrefixLength = childElements.size() - parentElements.size();
        if (uniquePrefixLength <= 0) {
            return "at " + childElements.get(0).toStringEventDumpFormat();
        }
        return EventDumpOperation.flowCallStackString(childElements.subList(0, uniquePrefixLength));
    }

    private static TroubleshootingOperationDefinition createOperationDefinition() {
        return new DefaultTroubleshootingOperationDefinition(EVENT_DUMP_OPERATION_NAME, EVENT_DUMP_OPERATION_DESCRIPTION, EventDumpOperation.createApplicationArgumentDefinition());
    }

    private static ArgumentDefinition createApplicationArgumentDefinition() {
        return new DefaultArgumentDefinition(APPLICATION_ARGUMENT_NAME, APPLICATION_ARGUMENT_DESCRIPTION, false);
    }

    private static class NestedEventsNode {
        private final String eventId;
        private final EventContextService.FlowStackEntry flowStack;
        private SortedMap<String, NestedEventsNode> directChildren = new TreeMap<String, NestedEventsNode>();

        public NestedEventsNode(String eventId, EventContextService.FlowStackEntry flowStack) {
            this.eventId = eventId;
            this.flowStack = flowStack;
        }

        public String getEventId() {
            return this.eventId;
        }

        public EventContextService.FlowStackEntry getFlowStack() {
            return this.flowStack;
        }

        public void addDirectChild(NestedEventsNode child) {
            this.directChildren.put(child.getEventId(), child);
        }

        public Collection<NestedEventsNode> getDirectChidren() {
            return this.directChildren.values();
        }
    }
}

