/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.pom.parser.internal;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomUtils;
import org.mule.maven.pom.parser.api.MavenPomParser;
import org.mule.maven.pom.parser.api.model.AdditionalPluginDependencies;
import org.mule.maven.pom.parser.api.model.ArtifactCoordinates;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.maven.pom.parser.api.model.BundleScope;
import org.mule.maven.pom.parser.api.model.MavenPomModel;
import org.mule.maven.pom.parser.api.model.SharedLibrary;
import org.mule.maven.pom.parser.internal.model.MavenPomModelWrapper;
import org.mule.maven.pom.parser.internal.util.MavenUtils;

public class MavenPomParserImpl
implements MavenPomParser {
    private static final String MULE_MAVEN_PLUGIN_GROUP_ID = "org.mule.tools.maven";
    private static final String MULE_MAVEN_PLUGIN_ARTIFACT_ID = "mule-maven-plugin";
    private static final String MULE_EXTENSIONS_PLUGIN_GROUP_ID = "org.mule.runtime.plugins";
    private static final String MULE_EXTENSIONS_PLUGIN_ARTIFACT_ID = "mule-extensions-maven-plugin";
    private static final String GROUP_ID = "groupId";
    private static final String ARTIFACT_ID = "artifactId";
    public static final String SHARED_LIBRARIES_FIELD = "sharedLibraries";
    public static final String SHARED_LIBRARY_FIELD = "sharedLibrary";
    public static final String DEFAULT_SOURCES_DIRECTORY = "src/main";
    private static final String VERSION = "version";
    private static final String MAVEN_SHADE_PLUGIN_ARTIFACT_ID = "maven-shade-plugin";
    private static final String ORG_APACHE_MAVEN_PLUGINS_GROUP_ID = "org.apache.maven.plugins";
    private static final String ADDITIONAL_PLUGIN_DEPENDENCIES_FIELD = "additionalPluginDependencies";
    private static final String PLUGIN_FIELD = "plugin";
    private static final String PLUGIN_DEPENDENCY_FIELD = "dependency";
    private static final String PLUGIN_DEPENDENCIES_FIELD = "additionalDependencies";
    private static final String DEFAULT_ARTIFACT_TYPE = "jar";
    private final Model pomModel;
    private final List<String> activeProfiles;
    private final Build build;

    public MavenPomParserImpl(Path path) {
        this(path, Collections.emptyList());
    }

    public MavenPomParserImpl(Path path, List<String> activeProfiles) {
        Objects.requireNonNull(path, "path cannot be null");
        this.pomModel = MavenUtils.getPomModel(path.toFile());
        this.activeProfiles = activeProfiles;
        this.build = this.pomModel.getBuild();
    }

    @Override
    public String getSourceDirectory() {
        return this.build.getSourceDirectory() != null ? this.build.getSourceDirectory() : DEFAULT_SOURCES_DIRECTORY;
    }

    @Override
    public List<String> getResourceDirectories() {
        return this.build.getResources().stream().map(FileSet::getDirectory).collect(Collectors.toList());
    }

    @Override
    public MavenPomModel getModel() {
        return new MavenPomModelWrapper(this.pomModel);
    }

    @Override
    public List<SharedLibrary> getSharedLibraries() {
        LinkedList shareLibrariesList = new LinkedList();
        this.findArtifactPackagerPlugin().ifPresent(plugin -> {
            Xpp3Dom[] sharedLibraries;
            Xpp3Dom sharedLibrariesDom;
            Object configuration = plugin.getConfiguration();
            if (configuration != null && (sharedLibrariesDom = ((Xpp3Dom)configuration).getChild(SHARED_LIBRARIES_FIELD)) != null && (sharedLibraries = sharedLibrariesDom.getChildren(SHARED_LIBRARY_FIELD)) != null) {
                for (Xpp3Dom sharedLibrary : sharedLibraries) {
                    String groupId = this.getAttribute(sharedLibrary, GROUP_ID);
                    String artifactId = this.getAttribute(sharedLibrary, ARTIFACT_ID);
                    shareLibrariesList.add(new SharedLibrary(groupId, artifactId));
                }
            }
        });
        return Collections.unmodifiableList(shareLibrariesList);
    }

    @Override
    public List<BundleDependency> getDependencies() {
        return this.pomModel.getDependencies().stream().map(this::toBundleDependency).collect(Collectors.toList());
    }

    @Override
    public Map<ArtifactCoordinates, AdditionalPluginDependencies> getPomAdditionalPluginDependenciesForArtifacts() {
        return this.findArtifactPackagerPlugin().map(this::getAdditionalPluginDependencies).orElse(Collections.emptyMap());
    }

    @Override
    public Properties getProperties() {
        return this.pomModel.getProperties();
    }

    @Override
    public boolean isMavenShadePluginConfigured() {
        if (this.pomModel.getBuild() != null) {
            for (Plugin plugin : this.pomModel.getBuild().getPlugins()) {
                if (!plugin.getGroupId().equals(ORG_APACHE_MAVEN_PLUGINS_GROUP_ID) || !plugin.getArtifactId().equals(MAVEN_SHADE_PLUGIN_ARTIFACT_ID)) continue;
                return true;
            }
        }
        return false;
    }

    private Optional<Plugin> findArtifactPackagerPlugin() {
        Stream basePlugin = Stream.empty();
        Build build = this.pomModel.getBuild();
        if (build != null) {
            basePlugin = this.findArtifactPackagerPlugin(build.getPlugins()).map(Stream::of).orElse(Stream.empty());
        }
        List sortedActiveProfiles = this.activeProfiles.stream().sorted(String::compareTo).collect(Collectors.toList());
        Stream<Plugin> packagerConfigsForActivePluginsStream = this.pomModel.getProfiles().stream().filter(profile -> sortedActiveProfiles.contains(profile.getId())).map(profile -> this.findArtifactPackagerPlugin(profile.getBuild() != null ? profile.getBuild().getPlugins() : null)).filter(plugin -> !plugin.equals(Optional.empty())).map(Optional::get);
        return Stream.concat(basePlugin, packagerConfigsForActivePluginsStream).reduce((p1, p2) -> {
            p1.setConfiguration(Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)((Xpp3Dom)p2.getConfiguration()), (Xpp3Dom)((Xpp3Dom)p1.getConfiguration())));
            p1.getDependencies().addAll(p2.getDependencies());
            return p1;
        });
    }

    private Optional<Plugin> findArtifactPackagerPlugin(List<Plugin> plugins) {
        if (plugins != null) {
            return plugins.stream().filter(plugin -> plugin.getArtifactId().equals(MULE_MAVEN_PLUGIN_ARTIFACT_ID) && plugin.getGroupId().equals(MULE_MAVEN_PLUGIN_GROUP_ID) || plugin.getArtifactId().equals(MULE_EXTENSIONS_PLUGIN_ARTIFACT_ID) && plugin.getGroupId().equals(MULE_EXTENSIONS_PLUGIN_GROUP_ID)).findFirst();
        }
        return Optional.empty();
    }

    private String getAttribute(Xpp3Dom tag, String attributeName) {
        Xpp3Dom attributeDom = tag.getChild(attributeName);
        this.checkState(attributeDom != null, String.format("'%s' element not declared at '%s' in the pom file", attributeName, tag.toString()));
        String attributeValue = attributeDom.getValue().trim();
        this.checkState(!StringUtils.isEmpty((String)attributeValue), String.format("'%s' was defined but has an empty value at '%s' declared in the pom file", attributeName, tag.toString()));
        return attributeValue;
    }

    private Map<ArtifactCoordinates, AdditionalPluginDependencies> getAdditionalPluginDependencies(Plugin packagingPlugin) {
        Xpp3Dom[] pluginsDom;
        Xpp3Dom additionalPluginDependenciesDom;
        HashMap<ArtifactCoordinates, AdditionalPluginDependencies> pluginsAdditionalLibraries = new HashMap<ArtifactCoordinates, AdditionalPluginDependencies>();
        Object configuration = packagingPlugin.getConfiguration();
        if (configuration != null && (additionalPluginDependenciesDom = ((Xpp3Dom)configuration).getChild(ADDITIONAL_PLUGIN_DEPENDENCIES_FIELD)) != null && (pluginsDom = additionalPluginDependenciesDom.getChildren(PLUGIN_FIELD)) != null) {
            for (Xpp3Dom pluginDom : pluginsDom) {
                String pluginGroupId = this.getChildParameterValue(pluginDom, GROUP_ID, true);
                String pluginArtifactId = this.getChildParameterValue(pluginDom, ARTIFACT_ID, true);
                ArrayList<BundleDescriptor> additionalDependencyDependencies = new ArrayList<BundleDescriptor>();
                Xpp3Dom dependenciesDom = pluginDom.getChild(PLUGIN_DEPENDENCIES_FIELD);
                if (dependenciesDom != null) {
                    for (Xpp3Dom dependencyDom : dependenciesDom.getChildren(PLUGIN_DEPENDENCY_FIELD)) {
                        BundleDescriptor.Builder dependency = new BundleDescriptor.Builder();
                        dependency.setGroupId(this.getChildParameterValue(dependencyDom, GROUP_ID, true));
                        dependency.setArtifactId(this.getChildParameterValue(dependencyDom, ARTIFACT_ID, true));
                        dependency.setVersion(this.getChildParameterValue(dependencyDom, VERSION, true));
                        String type = this.getChildParameterValue(dependencyDom, "type", false);
                        dependency.setType(type == null ? DEFAULT_ARTIFACT_TYPE : type);
                        dependency.setClassifier(this.getChildParameterValue(dependencyDom, "classifier", false));
                        dependency.setSystemPath(this.getChildParameterValue(dependencyDom, "systemPath", false));
                        additionalDependencyDependencies.add(dependency.build());
                    }
                }
                AdditionalPluginDependencies additionalPluginDependencies = new AdditionalPluginDependencies(pluginGroupId, pluginArtifactId, additionalDependencyDependencies);
                pluginsAdditionalLibraries.put(new ArtifactCoordinates(pluginGroupId, pluginArtifactId), additionalPluginDependencies);
            }
        }
        return pluginsAdditionalLibraries;
    }

    private String getChildParameterValue(Xpp3Dom element, String childName, boolean validate) {
        String childValue;
        Xpp3Dom child = element.getChild(childName);
        String string = childValue = child != null ? child.getValue() : null;
        if (StringUtils.isEmpty((String)childValue) && validate) {
            throw new IllegalArgumentException("Expecting child element with not null value " + childName);
        }
        return childValue;
    }

    private BundleDependency toBundleDependency(Dependency dependency) {
        BundleDescriptor descriptor = new BundleDescriptor.Builder().setGroupId(dependency.getGroupId()).setArtifactId(dependency.getArtifactId()).setVersion(dependency.getVersion()).setType(dependency.getType()).setExclusions(dependency.getExclusions().stream().map(exclusion -> new ArtifactCoordinates(exclusion.getGroupId(), exclusion.getArtifactId())).collect(Collectors.toList())).setClassifier(dependency.getClassifier()).setOptional(dependency.getOptional()).setSystemPath(dependency.getSystemPath()).build();
        BundleDependency.Builder builder = new BundleDependency.Builder().setDescriptor(descriptor);
        if (dependency.getScope() != null) {
            builder.setScope(BundleScope.valueOf(dependency.getScope().toUpperCase()));
        }
        return builder.build();
    }

    private void checkState(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }
}

