/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.rx;

import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.mule.runtime.core.internal.processor.interceptor.InterceptionException;

final class SynchronousScheduledFuture<V>
implements ScheduledFuture<V> {
    private V result;
    private Throwable thrown;
    private boolean interrupted;

    static <V> ScheduledFuture<V> synchronousSchedule(Callable<V> callable, long delay, TimeUnit unit) {
        try {
            Thread.sleep(unit.toMillis(delay));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new SynchronousScheduledFuture<V>(true);
        }
        try {
            return new SynchronousScheduledFuture<V>(callable.call());
        }
        catch (Exception e) {
            return new SynchronousScheduledFuture<V>(e);
        }
    }

    public SynchronousScheduledFuture(V result) {
        this.result = result;
    }

    public SynchronousScheduledFuture(Throwable thrown) {
        this.thrown = thrown;
    }

    public SynchronousScheduledFuture(boolean interrupted) {
        this.interrupted = interrupted;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return 0L;
    }

    @Override
    public int compareTo(Delayed o) {
        return o.getDelay(TimeUnit.MILLISECONDS) == 0L ? 0 : -1;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        if (this.interrupted) {
            throw new InterceptionException();
        }
        if (this.result != null) {
            return this.result;
        }
        throw new ExecutionException(this.thrown);
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.get();
    }
}

