/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.validator;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComposableModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.function.FunctionModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.nested.NestedChainModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.property.NoWrapperModelProperty;
import org.mule.runtime.extension.api.util.NameUtils;

public class NoWrapperModelValidator
implements ExtensionModelValidator {
    private static final String ERROR_PREFIX_REASON = "%s named %s is enriched with the NoWrapperModelProperty. %s";
    private static final String GENERIC_ERROR_REASON = "%ss are not allowed to be enriched with it.";
    private static final String PARAMETERS_ON_ENRICHED_COMPONENT = "A component cannot be enriched with the NoWrapperModelProperty and have parameters.";
    private static final String PARAMETER_OF_PROHIBITED_TYPE = "Parameters that are not array types or maps cannot be enriched with the NoWrapperModelProperty.";
    private static final String OWNER_IS_A_CHAIN = "A component cannot be enriched with the NoWrapperModelProperty if its owner is a Chain Model.";
    private static final String OWNER_IS_ALSO_ENRICHED = "Its owner is also enriched with the NoWrapperModelProperty. The owner and its child cannot be both enriched with it.";
    private static final String CHAIN_SIBILINGS_ENRICHED_FORMAT = "Component named %s has more than one nested chain enriched with the NoWrapperModelProperty [%s]. Only one chain child can be enriched with it.";
    private static final String PARAMETER_GROUP = "parameter group";
    private static final String PARAMETER = "parameter";

    @Override
    public void validate(ExtensionModel extensionModel, final ProblemsReporter problemsReporter) {
        new IdempotentExtensionWalker(){
            private Set<ComposableModel> visitedComposableModel = new HashSet<ComposableModel>();

            @Override
            protected void onParameterGroup(ParameterizedModel owner, ParameterGroupModel model) {
                NoWrapperModelValidator.this.validateNoWrapperIsNotPresent(model, NoWrapperModelValidator.PARAMETER_GROUP, problemsReporter);
            }

            @Override
            protected void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, final ParameterModel model) {
                model.getType().accept(new MetadataTypeVisitor(){

                    @Override
                    protected void defaultVisit(MetadataType metadataType) {
                        NoWrapperModelValidator.this.validateNoWrapperIsNotPresent(model, NoWrapperModelValidator.PARAMETER, problemsReporter, NoWrapperModelValidator.PARAMETER_OF_PROHIBITED_TYPE);
                    }

                    @Override
                    public void visitArrayType(ArrayType arrayType) {
                    }

                    @Override
                    public void visitObject(ObjectType objectType) {
                        if (!objectType.isOpen() || !objectType.getFields().isEmpty()) {
                            NoWrapperModelValidator.this.validateNoWrapperIsNotPresent(model, NoWrapperModelValidator.PARAMETER, problemsReporter, NoWrapperModelValidator.PARAMETER_OF_PROHIBITED_TYPE);
                        }
                    }
                });
            }

            @Override
            protected void onNestable(ComposableModel owner, NestableElementModel model) {
                if (this.visitedComposableModel.add(owner)) {
                    this.verifyChainChildren(owner);
                }
                if (owner instanceof NestedChainModel) {
                    NoWrapperModelValidator.this.validateNoWrapperIsNotPresent(model, NameUtils.getComponentModelTypeName(model), problemsReporter, NoWrapperModelValidator.OWNER_IS_A_CHAIN);
                }
                if (!model.getAllParameterModels().isEmpty()) {
                    NoWrapperModelValidator.this.validateNoWrapperIsNotPresent(model, NameUtils.getComponentModelTypeName(model), problemsReporter, NoWrapperModelValidator.PARAMETERS_ON_ENRICHED_COMPONENT);
                }
                if (owner instanceof EnrichableModel && ((EnrichableModel)((Object)owner)).getModelProperty(NoWrapperModelProperty.class).isPresent()) {
                    NoWrapperModelValidator.this.validateNoWrapperIsNotPresent(model, NameUtils.getComponentModelTypeName(model), problemsReporter, NoWrapperModelValidator.OWNER_IS_ALSO_ENRICHED);
                }
            }

            private void verifyChainChildren(ComposableModel owner) {
                List noWrappedChainNames = owner.getNestedComponents().stream().filter(nestedComponent -> nestedComponent.getModelProperty(NoWrapperModelProperty.class).isPresent() && nestedComponent instanceof NestedChainModel).map(nestedComponent -> nestedComponent.getName()).collect(Collectors.toList());
                if (noWrappedChainNames.size() > 1) {
                    problemsReporter.addError(new Problem(owner, String.format(NoWrapperModelValidator.CHAIN_SIBILINGS_ENRICHED_FORMAT, owner.getName(), String.join((CharSequence)", ", noWrappedChainNames))));
                }
            }

            @Override
            protected void onConnectionProvider(ConnectionProviderModel model) {
                NoWrapperModelValidator.this.validateNoWrapperIsNotPresent(model, NameUtils.getComponentModelTypeName(model), problemsReporter);
            }

            @Override
            protected void onSource(SourceModel model) {
                NoWrapperModelValidator.this.validateNoWrapperIsNotPresent(model, NameUtils.getComponentModelTypeName(model), problemsReporter);
            }

            @Override
            protected void onConstruct(ConstructModel model) {
                NoWrapperModelValidator.this.validateNoWrapperIsNotPresent(model, NameUtils.getComponentModelTypeName(model), problemsReporter);
            }

            @Override
            protected void onOperation(OperationModel model) {
                NoWrapperModelValidator.this.validateNoWrapperIsNotPresent(model, NameUtils.getComponentModelTypeName(model), problemsReporter);
            }

            @Override
            protected void onFunction(FunctionModel model) {
                NoWrapperModelValidator.this.validateNoWrapperIsNotPresent(model, NameUtils.getComponentModelTypeName(model), problemsReporter);
            }

            @Override
            protected void onConfiguration(ConfigurationModel model) {
                NoWrapperModelValidator.this.validateNoWrapperIsNotPresent(model, NameUtils.getComponentModelTypeName(model), problemsReporter);
            }
        }.walk(extensionModel);
    }

    private <T extends EnrichableModel & NamedObject> void validateNoWrapperIsNotPresent(T model, String modelType, ProblemsReporter problemsReporter) {
        if (model.getModelProperty(NoWrapperModelProperty.class).isPresent()) {
            String reason = String.format(GENERIC_ERROR_REASON, StringUtils.capitalize((String)modelType));
            this.validateNoWrapperIsNotPresent(model, modelType, problemsReporter, reason);
        }
    }

    private <T extends EnrichableModel & NamedObject> void validateNoWrapperIsNotPresent(T model, String modelType, ProblemsReporter problemsReporter, String reason) {
        if (model.getModelProperty(NoWrapperModelProperty.class).isPresent()) {
            problemsReporter.addError(new Problem((NamedObject)model, String.format(ERROR_PREFIX_REASON, StringUtils.capitalize((String)modelType), ((NamedObject)model).getName(), reason)));
        }
    }
}

