/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import org.mule.runtime.api.functional.Either;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.exception.IllegalSourceModelDefinitionException;
import org.mule.runtime.extension.api.runtime.source.SdkSourceFactory;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public final class DefaultSdkSourceFactory
implements SdkSourceFactory {
    private final Class<?> sourceType;
    private final boolean isLegacySourceType;

    public DefaultSdkSourceFactory(Class<?> sourceType) {
        IntrospectionUtils.checkInstantiable(sourceType, new ReflectionCache());
        if (Source.class.isAssignableFrom(sourceType)) {
            this.isLegacySourceType = true;
        } else if (org.mule.sdk.api.runtime.source.Source.class.isAssignableFrom(sourceType)) {
            this.isLegacySourceType = false;
        } else {
            throw new IllegalSourceModelDefinitionException(String.format("Source type %s must extend either %s or %s classes", sourceType.getName(), org.mule.sdk.api.runtime.source.Source.class.getName(), Source.class.getName()));
        }
        this.sourceType = sourceType;
    }

    @Override
    public Either<org.mule.sdk.api.runtime.source.Source, Source> createMessageSource() {
        try {
            Object source = ClassUtils.instantiateClass(this.sourceType, new Object[0]);
            return this.isLegacySourceType ? Either.right(org.mule.sdk.api.runtime.source.Source.class, (Source)source) : Either.left((org.mule.sdk.api.runtime.source.Source)source, Source.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception found trying to instantiate source type " + this.sourceType.getName(), e);
        }
    }
}

