/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.event;

import java.util.function.Supplier;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.event.EventQuickCopy;
import org.mule.runtime.core.internal.message.InternalEvent;

public class EventInternalContextResolver<CTX> {
    String internalParametersKey;
    Supplier<CTX> initialContextSupplier;

    public EventInternalContextResolver(String key, Supplier<CTX> initialContextSupplier) {
        this.internalParametersKey = key;
        this.initialContextSupplier = initialContextSupplier;
    }

    public CTX getCurrentContextFromEvent(CoreEvent event) {
        Object currentContext = ((InternalEvent)event).getInternalParameter(this.internalParametersKey);
        if (currentContext == null) {
            currentContext = this.initialContextSupplier.get();
        }
        return (CTX)currentContext;
    }

    public CoreEvent eventWithContext(CoreEvent event, CTX context) {
        return EventQuickCopy.quickCopy(event, SmallMap.of(this.internalParametersKey, context));
    }
}

