/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal.processor;

import org.apache.commons.lang3.ArrayUtils;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.config.internal.ArtifactAstConfigurationBuilder;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.internal.context.DefaultMuleContext;
import org.mule.runtime.core.internal.context.NullDomainMuleContextLifecycleStrategy;
import org.mule.runtime.deployment.model.api.artifact.ArtifactConfigurationProcessor;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContext;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContextConfiguration;
import org.mule.runtime.deployment.model.internal.artifact.ImmutableArtifactContext;

abstract class AbstractAstConfigurationProcessor
implements ArtifactConfigurationProcessor {
    AbstractAstConfigurationProcessor() {
    }

    @Override
    public ArtifactContext createArtifactContext(ArtifactContextConfiguration artifactContextConfiguration) throws ConfigurationException {
        if (ArrayUtils.isEmpty((Object[])artifactContextConfiguration.getConfigResources())) {
            return this.contextForEmptyArtifact(artifactContextConfiguration);
        }
        ArtifactAst artifactAst = this.obtainArtifactAst(artifactContextConfiguration);
        ArtifactAstConfigurationBuilder configurationBuilder = new ArtifactAstConfigurationBuilder(artifactAst, artifactContextConfiguration.getArtifactProperties(), artifactContextConfiguration.getArtifactType(), artifactContextConfiguration.isEnableLazyInitialization(), artifactContextConfiguration.isAddToolingObjectsToRegistry());
        artifactContextConfiguration.getParentArtifactContext().ifPresent(parentContext -> configurationBuilder.setParentContext(parentContext.getMuleContext(), parentContext.getArtifactAst()));
        artifactContextConfiguration.getServiceConfigurators().stream().forEach(configurationBuilder::addServiceConfigurator);
        configurationBuilder.configure(artifactContextConfiguration.getMuleContext());
        return configurationBuilder.createArtifactContext();
    }

    protected ArtifactContext contextForEmptyArtifact(ArtifactContextConfiguration artifactContextConfiguration) {
        ((DefaultMuleContext)artifactContextConfiguration.getMuleContext()).setLifecycleStrategy(new NullDomainMuleContextLifecycleStrategy());
        return new ImmutableArtifactContext(artifactContextConfiguration.getMuleContext());
    }

    protected abstract ArtifactAst obtainArtifactAst(ArtifactContextConfiguration var1) throws ConfigurationException;
}

