/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.delegate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.FunctionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSemanticTermsDeclaration;
import org.mule.runtime.module.extension.internal.loader.delegate.AbstractComponentModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.delegate.DefaultExtensionModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.parser.FunctionModelParser;
import org.mule.runtime.module.extension.internal.loader.utils.ModelLoaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FunctionModelLoaderDelegate
extends AbstractComponentModelLoaderDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(FunctionModelLoaderDelegate.class);
    private final Map<FunctionModelParser, FunctionDeclarer> functionDeclarers = new HashMap<FunctionModelParser, FunctionDeclarer>();

    FunctionModelLoaderDelegate(DefaultExtensionModelLoaderDelegate delegate) {
        super(delegate);
    }

    void declareFunctions(ExtensionDeclarer extensionDeclarer, List<FunctionModelParser> parsers) {
        for (FunctionModelParser parser : parsers) {
            if (parser.isIgnored()) continue;
            if (this.functionDeclarers.containsKey(parser)) {
                extensionDeclarer.withFunction(this.functionDeclarers.get(parser));
                continue;
            }
            FunctionDeclarer function = (FunctionDeclarer)extensionDeclarer.withFunction(parser.getName()).describedAs(parser.getDescription());
            parser.getDeprecationModel().ifPresent(function::withDeprecation);
            parser.getFunctionExecutorModelProperty().ifPresent(function::withModelProperty);
            parser.getOutputType().applyOn(function.withOutput());
            this.loader.getParameterModelsLoaderDelegate().declare(function, parser.getParameterGroupModelParsers());
            parser.getAdditionalModelProperties().forEach(function::withModelProperty);
            parser.getResolvedMinMuleVersion().ifPresent(resolvedMMV -> {
                function.withMinMuleVersion(resolvedMMV.getMinMuleVersion());
                LOGGER.debug(resolvedMMV.getReason());
            });
            ModelLoaderUtils.addSemanticTerms((WithSemanticTermsDeclaration)function.getDeclaration(), parser);
            this.functionDeclarers.put(parser, function);
        }
    }
}

