/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.event;

import java.nio.charset.Charset;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.mule.api.annotation.NoImplement;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.security.SecurityContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.message.GroupCorrelation;
import org.mule.runtime.core.api.transformer.MessageTransformerException;
import org.mule.runtime.core.internal.event.DefaultEventBuilder;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.privileged.connector.ReplyToHandler;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.event.MuleSession;
import org.slf4j.MDC;

@NoImplement
public interface PrivilegedEvent
extends CoreEvent {
    public static final String CORRELATION_ID_MDC_KEY = "correlationId";

    @Override
    public BaseEventContext getContext();

    @Deprecated
    public String getLegacyCorrelationId();

    @Deprecated
    public MuleSession getSession();

    @Deprecated
    public ReplyToHandler getReplyToHandler();

    @Deprecated
    public Object getReplyToDestination();

    public static PrivilegedEvent getCurrentEvent() {
        return (PrivilegedEvent)CurrentEventHolder.currentEvent.get();
    }

    public static void setCurrentEvent(PrivilegedEvent event) {
        CurrentEventHolder.currentEvent.set(event);
        if (event == null) {
            MDC.remove((String)CORRELATION_ID_MDC_KEY);
        } else {
            event.getLoggingVariables().ifPresent(variables -> variables.forEach(MDC::put));
            MDC.put((String)CORRELATION_ID_MDC_KEY, (String)event.getCorrelationId());
        }
    }

    public Optional<Map<String, String>> getLoggingVariables();

    @Deprecated
    public byte[] getMessageAsBytes(MuleContext var1) throws MuleException;

    @Deprecated
    public Object transformMessage(DataType var1, MuleContext var2) throws MessageTransformerException;

    @Deprecated
    public String getMessageAsString(MuleContext var1) throws MuleException;

    @Deprecated
    public String getMessageAsString(Charset var1, MuleContext var2) throws MuleException;

    public boolean isNotificationsEnabled();

    public static Builder builder(EventContext context) {
        return new DefaultEventBuilder((BaseEventContext)context);
    }

    public static Builder builder(CoreEvent event) {
        return new DefaultEventBuilder((InternalEvent)event);
    }

    public static Builder builder(EventContext context, CoreEvent event) {
        return new DefaultEventBuilder((BaseEventContext)context, (InternalEvent)event);
    }

    @NoImplement
    public static interface Builder
    extends CoreEvent.Builder {
        @Deprecated
        public Builder correlationId(String var1);

        @Deprecated
        public Builder replyToHandler(ReplyToHandler var1);

        @Deprecated
        public Builder replyToDestination(Object var1);

        @Deprecated
        public Builder disableNotifications();

        @Deprecated
        public Builder session(MuleSession var1);

        @Override
        public PrivilegedEvent build();

        @Override
        public Builder message(Message var1);

        @Override
        public Builder message(Function<EventContext, Message> var1);

        @Override
        public Builder variables(Map<String, ?> var1);

        public Builder variablesTyped(Map<String, TypedValue<?>> var1);

        @Override
        public Builder addVariable(String var1, Object var2);

        @Override
        public Builder addVariable(String var1, Object var2, DataType var3);

        @Override
        public Builder removeVariable(String var1);

        @Override
        public Builder clearVariables();

        public Builder addLoggingVariable(String var1, String var2);

        public Builder removeLoggingVariable(String var1);

        public Builder clearLoggingVariables();

        @Override
        @Deprecated
        public Builder groupCorrelation(Optional<GroupCorrelation> var1);

        @Override
        public Builder error(Error var1);

        @Override
        public Builder securityContext(SecurityContext var1);
    }

    public static class CurrentEventHolder {
        private static final ThreadLocal<PrivilegedEvent> currentEvent = new ThreadLocal();
    }
}

