/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.maven;

import com.vdurmont.semver4j.Semver;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.pom.parser.api.MavenPomParser;
import org.mule.maven.pom.parser.api.MavenPomParserProvider;
import org.mule.maven.pom.parser.api.model.AdditionalPluginDependencies;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.maven.pom.parser.api.model.Classifier;
import org.mule.maven.pom.parser.api.model.MavenPomModel;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;

public class AdditionalPluginDependenciesResolver {
    protected static final String MULE_APPLICATION_CLASSIFIER = "mule-application";
    private final File temporaryFolder;
    private final Map<ArtifactCoordinates, Supplier<MavenPomModel>> pomModels;
    private final MavenClient mavenClient;
    private final List<AdditionalPluginDependencies> pluginsWithAdditionalDependencies;

    public AdditionalPluginDependenciesResolver(MavenClient muleMavenPluginClient, List<AdditionalPluginDependencies> additionalPluginDependencies, File temporaryFolder) {
        this(muleMavenPluginClient, additionalPluginDependencies, temporaryFolder, Collections.emptyMap());
    }

    public AdditionalPluginDependenciesResolver(MavenClient muleMavenPluginClient, List<AdditionalPluginDependencies> additionalPluginDependencies, File temporaryFolder, Map<ArtifactCoordinates, Supplier<MavenPomModel>> pomModels) {
        this.mavenClient = muleMavenPluginClient;
        this.pluginsWithAdditionalDependencies = new ArrayList<AdditionalPluginDependencies>(additionalPluginDependencies);
        this.temporaryFolder = temporaryFolder;
        this.pomModels = pomModels;
    }

    public Map<BundleDependency, List<BundleDependency>> resolveDependencies(List<BundleDependency> applicationDependencies, Map<ArtifactCoordinates, List<Artifact>> pluginsDependencies) {
        this.addPluginDependenciesAdditionalLibraries(applicationDependencies);
        LinkedHashMap<BundleDependency, List<BundleDependency>> pluginsWithAdditionalDeps = new LinkedHashMap<BundleDependency, List<BundleDependency>>();
        for (AdditionalPluginDependencies pluginWithAdditionalDependencies : this.pluginsWithAdditionalDependencies) {
            BundleDependency pluginBundleDependency = this.getPluginBundleDependency(pluginWithAdditionalDependencies, applicationDependencies);
            List<Artifact> pluginDependencies = this.getPluginDependencies(pluginWithAdditionalDependencies, pluginsDependencies);
            List<BundleDependency> additionalDependencies = this.resolveDependencies(pluginWithAdditionalDependencies.getAdditionalDependencies().stream().filter(additionalDep -> pluginDependencies.stream().noneMatch(artifactDependency -> this.areSameArtifact((BundleDescriptor)additionalDep, (Artifact)artifactDependency))).collect(Collectors.toList()));
            if (additionalDependencies.isEmpty()) continue;
            pluginsWithAdditionalDeps.put(pluginBundleDependency, additionalDependencies);
        }
        return pluginsWithAdditionalDeps;
    }

    private List<BundleDependency> resolveDependencies(List<BundleDescriptor> additionalDependencies) {
        return this.mavenClient.resolveArtifactDependencies(additionalDependencies, Optional.of(this.mavenClient.getMavenConfiguration().getLocalMavenRepositoryLocation()), Optional.empty());
    }

    private BundleDependency getPluginBundleDependency(AdditionalPluginDependencies plugin, List<BundleDependency> mulePlugins) {
        return mulePlugins.stream().filter(mulePlugin -> StringUtils.equals((CharSequence)mulePlugin.getDescriptor().getArtifactId(), (CharSequence)plugin.getArtifactId()) && StringUtils.equals((CharSequence)mulePlugin.getDescriptor().getGroupId(), (CharSequence)plugin.getGroupId())).findFirst().orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Declared additional dependencies for a plugin not present: " + plugin)));
    }

    private List<Artifact> getPluginDependencies(AdditionalPluginDependencies plugin, Map<ArtifactCoordinates, List<Artifact>> pluginsDependencies) {
        return pluginsDependencies.entrySet().stream().filter(pluginDependenciesEntry -> StringUtils.equals((CharSequence)((ArtifactCoordinates)pluginDependenciesEntry.getKey()).getGroupId(), (CharSequence)plugin.getGroupId()) && StringUtils.equals((CharSequence)((ArtifactCoordinates)pluginDependenciesEntry.getKey()).getArtifactId(), (CharSequence)plugin.getArtifactId())).map(Map.Entry::getValue).findFirst().orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not find dependencies for plugin: " + plugin)));
    }

    private boolean areSameArtifact(BundleDescriptor dependency, Artifact artifact) {
        return StringUtils.equals((CharSequence)dependency.getArtifactId(), (CharSequence)artifact.getArtifactCoordinates().getArtifactId()) && StringUtils.equals((CharSequence)dependency.getGroupId(), (CharSequence)artifact.getArtifactCoordinates().getGroupId()) && StringUtils.equals((CharSequence)dependency.getVersion(), (CharSequence)artifact.getArtifactCoordinates().getVersion());
    }

    private void addPluginDependenciesAdditionalLibraries(List<BundleDependency> applicationDependencies) {
        List<BundleDependency> mulePlugins = applicationDependencies.stream().filter(bundleDependency -> Classifier.MULE_PLUGIN.equals((String)bundleDependency.getDescriptor().getClassifier().orElse(null))).collect(Collectors.toList());
        Collection<AdditionalPluginDependencies> additionalDependenciesFromMulePlugins = this.resolveAdditionalDependenciesFromMulePlugins(mulePlugins);
        this.pluginsWithAdditionalDependencies.addAll(additionalDependenciesFromMulePlugins.stream().filter(this.isNotRedefinedAtApplicationLevel()).collect(Collectors.toList()));
    }

    private Collection<AdditionalPluginDependencies> resolveAdditionalDependenciesFromMulePlugins(List<BundleDependency> mulePlugins) {
        HashMap additionalDependenciesFromMulePlugins = new HashMap();
        mulePlugins.stream().filter(mulePlugin -> {
            Supplier<MavenPomModel> modelSupplier = this.pomModels.get(this.getArtifactCoordinates((BundleDependency)mulePlugin));
            if (modelSupplier != null) {
                return modelSupplier.get().getPackaging().equals(MULE_APPLICATION_CLASSIFIER);
            }
            return this.mavenClient.getRawPomModel(new File(mulePlugin.getBundleUri())).getPackaging().equals(MULE_APPLICATION_CLASSIFIER);
        }).forEach(mulePlugin -> {
            Supplier<MavenPomModel> pomModel = this.pomModels.getOrDefault(this.getArtifactCoordinates((BundleDependency)mulePlugin), () -> this.mavenClient.getEffectiveModel(new File(mulePlugin.getBundleUri()), Optional.of(this.temporaryFolder)));
            MavenPomParser mavenPomParser = MavenPomParserProvider.discoverProvider().createMavenPomParserClient(pomModel.get().getPomFile().get().toPath());
            mavenPomParser.getPomAdditionalPluginDependenciesForArtifacts().values().forEach(mavenPlugin -> {
                String artifact = mavenPlugin.getGroupId() + ":" + mavenPlugin.getArtifactId();
                AdditionalPluginDependencies alreadyDefinedPluginAdditionalDependencies = (AdditionalPluginDependencies)additionalDependenciesFromMulePlugins.get(artifact);
                if (alreadyDefinedPluginAdditionalDependencies != null) {
                    LinkedList<BundleDescriptor> effectiveDependencies = new LinkedList<BundleDescriptor>(alreadyDefinedPluginAdditionalDependencies.getAdditionalDependencies());
                    mavenPlugin.getAdditionalDependencies().forEach(additionalDependenciesDependency -> {
                        boolean addDependency = true;
                        for (int i = 0; i < effectiveDependencies.size(); ++i) {
                            BundleDescriptor effectiveDependency = (BundleDescriptor)effectiveDependencies.get(i);
                            if (!effectiveDependency.getGroupId().equals(additionalDependenciesDependency.getGroupId()) || !effectiveDependency.getArtifactId().equals(additionalDependenciesDependency.getArtifactId()) || !effectiveDependency.getType().equals(additionalDependenciesDependency.getType()) || !effectiveDependency.getClassifier().equals(additionalDependenciesDependency.getClassifier())) continue;
                            if (this.isNewerVersion(additionalDependenciesDependency.getVersion(), effectiveDependency.getVersion())) {
                                effectiveDependencies.remove(i);
                                break;
                            }
                            addDependency = false;
                            break;
                        }
                        if (addDependency) {
                            effectiveDependencies.add((BundleDescriptor)additionalDependenciesDependency);
                        }
                    });
                    AdditionalPluginDependencies alreadyDefinedEffectivePluginAdditionalDependencies = new AdditionalPluginDependencies(alreadyDefinedPluginAdditionalDependencies, effectiveDependencies);
                    additionalDependenciesFromMulePlugins.replace(artifact, alreadyDefinedEffectivePluginAdditionalDependencies);
                } else {
                    additionalDependenciesFromMulePlugins.put(mavenPlugin.getGroupId() + ":" + mavenPlugin.getArtifactId(), mavenPlugin);
                }
            });
        });
        return additionalDependenciesFromMulePlugins.values();
    }

    private boolean isNewerVersion(String dependencyA, String dependencyB) {
        try {
            return new Semver(dependencyA, Semver.SemverType.LOOSE).isGreaterThan(new Semver(dependencyB, Semver.SemverType.LOOSE));
        }
        catch (IllegalArgumentException e) {
            return dependencyA.compareTo(dependencyB) > 0;
        }
    }

    private ArtifactCoordinates getArtifactCoordinates(BundleDependency mulePlugin) {
        BundleDescriptor descriptor = mulePlugin.getDescriptor();
        return new ArtifactCoordinates(descriptor.getGroupId(), descriptor.getArtifactId(), descriptor.getVersion());
    }

    private Predicate<AdditionalPluginDependencies> isNotRedefinedAtApplicationLevel() {
        return dependencyPluginAdditionalDependencies -> !this.pluginsWithAdditionalDependencies.stream().filter(applicationPluginAdditionalDependency -> dependencyPluginAdditionalDependencies.getGroupId().equals(applicationPluginAdditionalDependency.getGroupId()) && dependencyPluginAdditionalDependencies.getArtifactId().equals(applicationPluginAdditionalDependency.getArtifactId())).findAny().isPresent();
    }
}

