/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.meta.model.ExternalLibraryModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.notification.NotificationModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.internal.model.ExtensionModelHelper;
import org.mule.runtime.extension.api.dsl.syntax.DslSyntaxUtils;
import org.mule.runtime.module.extension.internal.loader.java.property.ArtifactLifecycleListenerModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ExceptionHandlerModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.ConfigurationModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.ConnectionProviderModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.ErrorModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.ExtensionModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.FunctionModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.OperationModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.SourceModelParser;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.mule.internal.loader.parser.BaseMuleSdkExtensionModelParser;
import org.mule.runtime.module.extension.mule.internal.loader.parser.MuleSdkOperationModelParser;

public abstract class MuleSdkExtensionModelParser
extends BaseMuleSdkExtensionModelParser
implements ExtensionModelParser {
    private final TypeLoader typeLoader;
    private List<OperationModelParser> operationModelParsers;
    private final ExtensionModelHelper extensionModelHelper;
    private Set<String> supportedJavaVersions;

    public MuleSdkExtensionModelParser(TypeLoader typeLoader, ExtensionModelHelper extensionModelHelper) {
        this.typeLoader = typeLoader;
        this.extensionModelHelper = extensionModelHelper;
    }

    protected void init(ArtifactAst ast) {
        this.supportedJavaVersions = MuleExtensionUtils.getValidatedJavaVersionsIntersection(this.getName(), "Extension", ast.dependencies());
        this.operationModelParsers = this.computeOperationModelParsers(ast);
    }

    @Override
    public List<ModelProperty> getAdditionalModelProperties() {
        return Collections.emptyList();
    }

    @Override
    public List<ConfigurationModelParser> getConfigurationParsers() {
        return Collections.emptyList();
    }

    @Override
    public List<OperationModelParser> getOperationModelParsers() {
        return this.operationModelParsers;
    }

    @Override
    public List<SourceModelParser> getSourceModelParsers() {
        return Collections.emptyList();
    }

    @Override
    public List<ConnectionProviderModelParser> getConnectionProviderModelParsers() {
        return Collections.emptyList();
    }

    @Override
    public List<FunctionModelParser> getFunctionModelParsers() {
        return Collections.emptyList();
    }

    @Override
    public List<ErrorModelParser> getErrorModelParsers() {
        return Collections.emptyList();
    }

    @Override
    public List<ExternalLibraryModel> getExternalLibraryModels() {
        return Collections.emptyList();
    }

    @Override
    public Optional<ExceptionHandlerModelProperty> getExtensionHandlerModelProperty() {
        return Optional.empty();
    }

    @Override
    public Optional<DeprecationModel> getDeprecationModel() {
        return Optional.empty();
    }

    @Override
    public List<MetadataType> getExportedTypes() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getExportedResources() {
        return Collections.emptyList();
    }

    @Override
    public List<MetadataType> getImportedTypes() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getPrivilegedExportedArtifacts() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getPrivilegedExportedPackages() {
        return Collections.emptyList();
    }

    @Override
    public Map<MetadataType, List<MetadataType>> getSubTypes() {
        return Collections.emptyMap();
    }

    @Override
    public List<NotificationModel> getNotificationModels() {
        return Collections.emptyList();
    }

    @Override
    public Optional<ArtifactLifecycleListenerModelProperty> getArtifactLifecycleListenerModelProperty() {
        return Optional.empty();
    }

    @Override
    public Set<String> getSupportedJavaVersions() {
        return this.supportedJavaVersions;
    }

    protected abstract Stream<ComponentAst> getTopLevelElements(ArtifactAst var1);

    private List<OperationModelParser> computeOperationModelParsers(ArtifactAst ast) {
        Map operationParsersByName = this.getTopLevelElements(ast).filter(c -> c.getComponentType() == TypedComponentIdentifier.ComponentType.OPERATION_DEF).map(c -> this.createOperationModelParser((ComponentAst)c, this.getNamespace())).collect(Collectors.toMap(c -> DslSyntaxUtils.getSanitizedElementName(c::getName), Function.identity()));
        operationParsersByName.values().forEach(operationModelParser -> operationModelParser.computeCharacteristics(operationParsersByName));
        return new ArrayList<OperationModelParser>(operationParsersByName.values());
    }

    protected MuleSdkOperationModelParser createOperationModelParser(ComponentAst operation, String namespace) {
        return new MuleSdkOperationModelParser(operation, namespace, this.typeLoader, this.extensionModelHelper);
    }
}

