/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader.parser.ast;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.mule.runtime.api.artifact.ArtifactCoordinates;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.module.artifact.activation.internal.ast.AbstractMuleSdkExtensionModelLoadingMediator;

public class MuleSdkPluginExtensionModelLoadingMediator
extends AbstractMuleSdkExtensionModelLoadingMediator {
    private static final Set<TypedComponentIdentifier.ComponentType> REUSABLE_COMPONENT_TYPES = Collections.singleton(TypedComponentIdentifier.ComponentType.OPERATION_DEF);
    private final String version;
    private final ExtensionModelLoader extensionModelLoader;
    private final Consumer<ExtensionModel> onNewExtensionModel;

    public MuleSdkPluginExtensionModelLoadingMediator(ExpressionLanguageMetadataService expressionLanguageMetadataService, Optional<ArtifactCoordinates> artifactCoordinates, String version, ExtensionModelLoader extensionModelLoader, Consumer<ExtensionModel> onNewExtensionModel) {
        super(artifactCoordinates, expressionLanguageMetadataService);
        this.version = version;
        this.extensionModelLoader = extensionModelLoader;
        this.onNewExtensionModel = onNewExtensionModel;
    }

    @Override
    public Optional<ExtensionModel> loadExtensionModel(ArtifactAst ast, ClassLoader classLoader, Set<ExtensionModel> extensions) throws ConfigurationException {
        Optional<ExtensionModel> extensionModel = super.loadExtensionModel(ast, classLoader, extensions);
        extensionModel.ifPresent(this.onNewExtensionModel);
        return extensionModel;
    }

    @Override
    protected String getVersion() throws ConfigurationException {
        return this.artifactCoordinates.map(ArtifactCoordinates::getVersion).orElse(this.version);
    }

    @Override
    protected ExtensionModelLoader getLoader() throws ConfigurationException {
        return this.extensionModelLoader;
    }

    @Override
    protected boolean containsReusableComponents(ArtifactAst ast) {
        return ast.topLevelComponentsStream().anyMatch(component -> REUSABLE_COMPONENT_TYPES.contains((Object)component.getComponentType()));
    }
}

