/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.exporter.impl.optel.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.ast.api.exception.PropertyNotFoundException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.tracer.exporter.config.api.SpanExporterConfiguration;
import org.mule.runtime.tracer.exporter.config.impl.FileSpanExporterConfiguration;
import org.mule.runtime.tracer.exporter.impl.optel.config.CompositeSpanExporterConfiguration;
import org.mule.runtime.tracer.exporter.impl.optel.config.EnvironmentPropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetryAutoConfigurableSpanExporterConfiguration
implements SpanExporterConfiguration,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenTelemetryAutoConfigurableSpanExporterConfiguration.class);
    @Inject
    private MuleContext muleContext;
    private static final String DEFAULT_BACKOFF_MULTIPLIER = "1.5";
    private static final String DEFAULT_INITIAL_BACKOFF = "1";
    private static final String DEFAULT_MAXIMUM_BACKOFF = "5";
    private static final String DEFAULT_BACKOFF_MAX_ATTEMPTS = "5";
    private static final String GRPC_EXPORTER_TYPE = "GRPC";
    private static final String DEFAULT_EXPORTER_TYPE = "GRPC";
    private static final String DEFAULT_GRPC_EXPORTER_ENDPOINT = "http://localhost:4317";
    private static final String DEFAULT_HTTP_EXPORTER_ENDPOINT = "http://localhost:4318/v1/traces";
    private static final String DEFAULT_EXPORTER_TIMEOUT = "10000";
    private static final String DEFAULT_STATISTICS_LOG_FREQUENCY = "30000";
    private static final String DEFAULT_BATCH_QUEUE_SIZE = "2048";
    private static final String DEFAULT_MAX_BATCH_SIZE = "512";
    private static final String DEFAULT_SCHEDULED_DELAY = "5000";
    private static final String DEFAULT_SAMPLER = "parentbased_traceidratio";
    private static final String DEFAULT_SAMPLER_ARG = "0.1";
    private SpanExporterConfiguration delegate;
    private final Map<String, String> defaultConfigurationValues = new HashMap<String, String>();
    private final List<Runnable> runnablesOnChange = Collections.synchronizedList(new ArrayList());

    public OpenTelemetryAutoConfigurableSpanExporterConfiguration() {
    }

    public OpenTelemetryAutoConfigurableSpanExporterConfiguration(SpanExporterConfiguration delegate) {
        this.delegate = delegate;
        this.initialiseDefaultConfigurationValues();
    }

    @Override
    public String getStringValue(String key) {
        try {
            if (this.delegate == null) {
                this.delegate = new CompositeSpanExporterConfiguration(Arrays.asList(new FileSpanExporterConfiguration(this.muleContext), new EnvironmentPropertiesConfiguration()));
                this.delegate.doOnConfigurationChanged(() -> this.runnablesOnChange.forEach(Runnable::run));
                this.initialiseDefaultConfigurationValues();
            }
            return this.delegate.getStringValue(key, this.defaultConfigurationValues.get(key));
        }
        catch (PropertyNotFoundException e) {
            return this.defaultConfigurationValues.get(key);
        }
    }

    private void initialiseDefaultConfigurationValues() {
        this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.enabled", "false");
        this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.type", "GRPC");
        if (this.getStringValue("mule.openTelemetry.tracer.exporter.type").equals("GRPC")) {
            this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.endpoint", DEFAULT_GRPC_EXPORTER_ENDPOINT);
        } else {
            this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.endpoint", DEFAULT_HTTP_EXPORTER_ENDPOINT);
        }
        this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.timeout", DEFAULT_EXPORTER_TIMEOUT);
        this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.backoff.multiplier", DEFAULT_BACKOFF_MULTIPLIER);
        this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.backoff.initial", DEFAULT_INITIAL_BACKOFF);
        this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.backoff.maximum", "5");
        this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.backoff.maxAttempts", "5");
        this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.metricsLogFrequency", DEFAULT_STATISTICS_LOG_FREQUENCY);
        this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.batch.maxSize", DEFAULT_MAX_BATCH_SIZE);
        this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.batch.queueSize", DEFAULT_BATCH_QUEUE_SIZE);
        this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.batch.scheduledDelay", DEFAULT_SCHEDULED_DELAY);
        this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.sampler", DEFAULT_SAMPLER);
        this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.sampler.arg", DEFAULT_SAMPLER_ARG);
    }

    @Override
    public void doOnConfigurationChanged(Runnable doOnChange) {
        this.runnablesOnChange.add(doOnChange);
    }

    @Override
    public void dispose() {
        if (this.delegate != null) {
            LifecycleUtils.disposeIfNeeded(this.delegate, LOGGER);
        }
    }
}

