/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source.legacy;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Consumer;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.core.internal.util.message.SdkResultAdapter;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.PollContext;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.module.extension.internal.runtime.source.legacy.LegacyPollItemStatusUtils;
import org.mule.runtime.module.extension.internal.runtime.source.legacy.LegacySourceCallbackContextAdapter;
import org.mule.sdk.api.runtime.source.PollContext;

public class LegacyPollContextAdapter<T, A>
implements org.mule.runtime.extension.api.runtime.source.PollContext<T, A> {
    private final PollContext delegate;

    public LegacyPollContextAdapter(PollContext<T, A> delegate) {
        this.delegate = delegate;
    }

    @Override
    public PollContext.PollItemStatus accept(Consumer<PollContext.PollItem<T, A>> consumer) {
        return LegacyPollItemStatusUtils.from(this.delegate.accept(new PollItemConsumerAdapter<T, A>(consumer)));
    }

    @Override
    public Optional<Serializable> getWatermark() {
        return this.delegate.getWatermark();
    }

    @Override
    public boolean isSourceStopping() {
        return this.delegate.isSourceStopping();
    }

    @Override
    public void setWatermarkComparator(Comparator<? extends Serializable> comparator) {
        this.delegate.setWatermarkComparator(comparator);
    }

    @Override
    public void onConnectionException(ConnectionException e) {
        this.delegate.onConnectionException(e);
    }

    private static class PollItemConsumerAdapter<T, A>
    implements Consumer<PollContext.PollItem<T, A>> {
        Consumer<PollContext.PollItem<T, A>> delegate;

        PollItemConsumerAdapter(Consumer<PollContext.PollItem<T, A>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void accept(PollContext.PollItem pollItem) {
            this.delegate.accept(new SdkToLegacyPollItemAdapter(pollItem));
        }

        private static class SdkToLegacyPollItemAdapter
        implements PollContext.PollItem {
            PollContext.PollItem delegate;

            public SdkToLegacyPollItemAdapter(PollContext.PollItem delegate) {
                this.delegate = delegate;
            }

            @Override
            public SourceCallbackContext getSourceCallbackContext() {
                return new LegacySourceCallbackContextAdapter(this.delegate.getSourceCallbackContext());
            }

            public PollContext.PollItem setResult(Result result) {
                this.delegate.setResult(SdkResultAdapter.from(result));
                return this;
            }

            public PollContext.PollItem setWatermark(Serializable watermark) {
                this.delegate.setWatermark(watermark);
                return this;
            }

            public PollContext.PollItem setId(String id) {
                this.delegate.setId(id);
                return this;
            }
        }
    }
}

