/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.stereotype.HasStereotypeModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ComponentGenerationInformation;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.MetadataTypeAdapter;
import org.mule.runtime.ast.api.builder.ComponentAstBuilder;
import org.mule.runtime.ast.api.exception.PropertyNotFoundException;
import org.mule.runtime.ast.internal.DefaultComponentGenerationInformation;
import org.mule.runtime.ast.internal.DefaultComponentParameterAst;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;
import org.mule.runtime.ast.internal.error.ErrorTypeBuilder;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.error.ErrorMapping;
import org.mule.runtime.extension.api.property.NoWrapperModelProperty;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.NameUtils;

public abstract class BaseComponentAstBuilder<B extends BaseComponentAstBuilder>
implements ComponentAstBuilder {
    public static final String BODY_RAW_PARAM_NAME = "$%body%$";
    private static final String ERROR_HANDLER = "error-handler";
    private static final ComponentIdentifier ERROR_HANDLER_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("error-handler").build();
    private static final ComponentIdentifier ERROR_MAPPING_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("error-mapping").build();
    public static final String SOURCE_TYPE = "sourceType";
    public static final String TARGET_TYPE = "targetType";
    private final PropertiesResolver propertiesResolver;
    private final List<B> childComponents = new ArrayList<B>();
    private final Set<B> paramsChildren = new HashSet<B>();
    private final Map<String, String> rawParameters = new HashMap<String, String>();
    private final Map<Pair<ParameterModel, ParameterGroupModel>, ComponentParameterAst> parameters = new HashMap<Pair<ParameterModel, ParameterGroupModel>, ComponentParameterAst>();
    private final Set<String> parameterNames = new HashSet<String>();
    private final Map<String, Object> annotations = new HashMap<String, Object>();
    private ExtensionModel extensionModel;
    private ComponentModel componentModel;
    private NestableElementModel nestableElementModel;
    private ConfigurationModel configurationModel;
    private ConnectionProviderModel connectionProviderModel;
    private ParameterizedModel parameterizedModel;
    private MetadataType type;
    private ComponentMetadataAst metadata;
    private ComponentLocation location;
    private ComponentIdentifier identifier;
    private TypedComponentIdentifier.ComponentType componentType = TypedComponentIdentifier.ComponentType.UNKNOWN;
    private final DefaultComponentGenerationInformation.Builder generationInformationBuilder = DefaultComponentGenerationInformation.builder();
    protected Supplier<Optional<String>> componentId;

    public BaseComponentAstBuilder(PropertiesResolver propertiesResolver) {
        this.propertiesResolver = propertiesResolver;
    }

    public ComponentAstBuilder addChildComponent(B childComponent) {
        this.childComponents.add(childComponent);
        return this;
    }

    @Override
    public ComponentAstBuilder withRawParameter(String paramName, String paramRawValue) {
        this.rawParameters.put(paramName, paramRawValue);
        return this;
    }

    @Override
    public ComponentAstBuilder withBodyParameter(String parameterRawValue) {
        return this.withRawParameter(BODY_RAW_PARAM_NAME, parameterRawValue);
    }

    @Override
    public ComponentAstBuilder withAnnotation(String name, Object value) {
        this.annotations.put(name, value);
        return this;
    }

    public BaseComponentAstBuilder<B> withParameter(ParameterModel paramModel, ParameterGroupModel parameterGroupModel, ComponentParameterAst paramValue, Optional<ComponentIdentifier> paramIdentifier) {
        return this.withParameter(paramModel, parameterGroupModel, paramValue, paramIdentifier.map(Collections::singleton).orElse(Collections.emptySet()));
    }

    public BaseComponentAstBuilder<B> withParameter(ParameterModel paramModel, ParameterGroupModel parameterGroupModel, ComponentParameterAst paramValue, Iterable<ComponentIdentifier> paramIdentifiers) {
        paramIdentifiers.forEach(this::doRemoveParamChild);
        this.parameterNames.add(paramModel.getName());
        Pair<ParameterModel, ParameterGroupModel> paramAndGroupPair = new Pair<ParameterModel, ParameterGroupModel>(paramModel, parameterGroupModel);
        if (this.parameters.put(paramAndGroupPair, paramValue) != null) {
            throw new IllegalStateException("Param '" + paramModel.getName() + "' is already present in " + this.getIdentifier() + " @ " + this.getMetadata().getStartLine());
        }
        return this;
    }

    public void prepareForBuild() {
        this.getModel(ParameterizedModel.class).ifPresent(pmzd -> pmzd.getParameterGroupModels().forEach(pmg -> pmg.getParameterModels().forEach(pm -> this.removeParamChild((ParameterModel)pm, (ParameterGroupModel)pmg))));
        this.getModel(SourceModel.class).ifPresent(sm -> {
            sm.getSuccessCallback().ifPresent(scbk -> scbk.getParameterGroupModels().forEach(pmg -> pmg.getParameterModels().forEach(pm -> this.removeParamChild((ParameterModel)pm, (ParameterGroupModel)pmg))));
            sm.getErrorCallback().ifPresent(ecbk -> ecbk.getParameterGroupModels().forEach(pmg -> pmg.getParameterModels().forEach(pm -> this.removeParamChild((ParameterModel)pm, (ParameterGroupModel)pmg))));
        });
    }

    protected void removeParamChild(final ParameterModel paramModel, ParameterGroupModel parameterGroupModel) {
        final AtomicReference childToRemove = new AtomicReference();
        if (parameterGroupModel.isShowInDsl()) {
            DslElementSyntax syntax = this.generationInformationBuilder.getSyntax();
            if (syntax != null) {
                syntax.getChild(parameterGroupModel.getName()).map(this.syntaxToComponentIdentifier()).ifPresent(childToRemove::set);
            }
        } else {
            final DslElementSyntax syntax = this.generationInformationBuilder.getSyntax();
            if (syntax != null) {
                paramModel.getType().accept(new MetadataTypeVisitor(){

                    @Override
                    public void visitObject(ObjectType objectType) {
                        if (ExtensionMetadataTypeUtils.isMap(objectType)) {
                            syntax.getChild(paramModel.getName()).map(s -> paramModel.getModelProperty(NoWrapperModelProperty.class).flatMap(noWrapper -> objectType.getOpenRestriction().flatMap(r -> s.getGeneric((MetadataType)r))).orElse(s)).map(BaseComponentAstBuilder.this.syntaxToComponentIdentifier()).ifPresent(childToRemove::set);
                        } else {
                            syntax.getChild(paramModel.getName()).filter(x -> x.isWrapped()).map(BaseComponentAstBuilder.this.syntaxToComponentIdentifier()).ifPresent(childToRemove::set);
                        }
                    }

                    @Override
                    public void visitArrayType(ArrayType arrayType) {
                        arrayType.getType().accept(new MetadataTypeVisitor(){

                            @Override
                            public void defaultVisit(MetadataType metadataType) {
                                syntax.getGeneric(metadataType).map(BaseComponentAstBuilder.this.syntaxToComponentIdentifier()).ifPresent(childToRemove::set);
                            }
                        });
                    }
                });
            }
        }
        this.doRemoveParamChild((ComponentIdentifier)childToRemove.get());
    }

    private Function<? super DslElementSyntax, ? extends ComponentIdentifier> syntaxToComponentIdentifier() {
        return syntax -> ComponentIdentifier.builder().name(syntax.getElementName()).namespace(syntax.getPrefix()).namespaceUri(syntax.getNamespace()).build();
    }

    protected void doRemoveParamChild(ComponentIdentifier componentIdentifier) {
        if (componentIdentifier != null) {
            Iterator<B> iterator = this.childComponents.iterator();
            while (iterator.hasNext()) {
                BaseComponentAstBuilder b = (BaseComponentAstBuilder)iterator.next();
                if (!b.getIdentifier().equals(componentIdentifier) && !this.singularizeComponentIdentifier(b.getIdentifier()).equals(componentIdentifier)) continue;
                iterator.remove();
                this.paramsChildren.add(b);
            }
        }
    }

    private ComponentIdentifier singularizeComponentIdentifier(ComponentIdentifier identifier) {
        return ComponentIdentifier.builder().name(NameUtils.singularize(identifier.getName())).namespace(identifier.getNamespace()).namespaceUri(identifier.getNamespaceUri()).build();
    }

    public Map<String, String> getRawParameters() {
        return Collections.unmodifiableMap(this.rawParameters);
    }

    protected Map<Pair<ParameterModel, ParameterGroupModel>, ComponentParameterAst> createParameterAsts() {
        if (!this.getModel(ParameterizedModel.class).isPresent()) {
            return Collections.emptyMap();
        }
        HashMap<Pair<ParameterModel, ParameterGroupModel>, ComponentParameterAst> parameterAsts = new HashMap<Pair<ParameterModel, ParameterGroupModel>, ComponentParameterAst>(this.parameters);
        this.getModel(ParameterizedModel.class).ifPresent(parameterized -> {
            this.parameterizedModel = parameterized;
            this.getModel(SourceModel.class).map(sourceModel -> Stream.concat(parameterized.getParameterGroupModels().stream(), Stream.concat(sourceModel.getSuccessCallback().map(cb -> cb.getParameterGroupModels().stream()).orElse(Stream.empty()), sourceModel.getErrorCallback().map(cb -> cb.getParameterGroupModels().stream()).orElse(Stream.empty())))).orElse(parameterized.getParameterGroupModels().stream()).forEach(pg -> {
                if (pg.isShowInDsl()) {
                    this.populateNestedParameterAsts(parameterAsts, (ParameterGroupModel)pg);
                } else {
                    this.populateFlatGroupParameterAsts(parameterAsts, (ParameterGroupModel)pg);
                }
            });
        });
        return parameterAsts.values().stream().sorted(new Comparator<ComponentParameterAst>(){
            final List<String> params;
            {
                this.params = BaseComponentAstBuilder.this.parameterizedModel.getAllParameterModels().stream().map(NamedObject::getName).collect(Collectors.toList());
            }

            @Override
            public int compare(ComponentParameterAst o1, ComponentParameterAst o2) {
                return Integer.compare(this.params.indexOf(o1.getModel().getName()), this.params.indexOf(o2.getModel().getName()));
            }
        }).collect(Collectors.toMap(k -> new Pair<ParameterModel, ParameterGroupModel>(k.getModel(), k.getGroupModel()), Function.identity(), (u, v) -> u, LinkedHashMap::new));
    }

    private void populateNestedParameterAsts(Map<Pair<ParameterModel, ParameterGroupModel>, ComponentParameterAst> parameterAsts, ParameterGroupModel pg) {
        Optional<BaseComponentAstBuilder> paramGroupComp = this.paramsChildren.stream().filter(comp -> this.generationInformationBuilder.getSyntax().getChild(pg.getName()).map(childSyntax -> childSyntax.getElementName().equals(comp.getIdentifier().getName())).orElse(false)).findAny();
        if (paramGroupComp.isPresent()) {
            pg.getParameterModels().forEach(paramModel -> this.populateParameterAst(parameterAsts, Optional.ofNullable(((BaseComponentAstBuilder)paramGroupComp.get()).getRawParameters().get(paramModel.getName())), pg, (ParameterModel)paramModel));
        } else {
            pg.getParameterModels().forEach(paramModel -> this.populateParameterAst(parameterAsts, Optional.empty(), pg, (ParameterModel)paramModel));
        }
    }

    private void populateFlatGroupParameterAsts(Map<Pair<ParameterModel, ParameterGroupModel>, ComponentParameterAst> parameterAsts, ParameterGroupModel pg) {
        pg.getParameterModels().forEach(paramModel -> {
            if ("errorMappings".equals(paramModel.getName())) {
                this.populateErrorMappings(parameterAsts, pg, (ParameterModel)paramModel);
            } else {
                this.populateParameterAst(parameterAsts, Optional.ofNullable(this.rawParameters.get(paramModel.getName())), pg, (ParameterModel)paramModel);
            }
        });
    }

    private void populateErrorMappings(Map<Pair<ParameterModel, ParameterGroupModel>, ComponentParameterAst> parameterAsts, ParameterGroupModel pg, ParameterModel paramModel) {
        List<ErrorMapping> errorMappings = this.childComponents.stream().filter(child -> ERROR_MAPPING_IDENTIFIER.equals(child.getIdentifier())).map(child -> new ErrorMapping(Optional.ofNullable(child.getRawParameters().get(SOURCE_TYPE)).orElse(ErrorTypeBuilder.ANY_IDENTIFIER), child.getRawParameters().get(TARGET_TYPE))).collect(Collectors.toList());
        DefaultComponentGenerationInformation.Builder generationInfoBuilder = DefaultComponentGenerationInformation.builder();
        if (this.generationInformationBuilder.getSyntax() != null) {
            this.generationInformationBuilder.getSyntax().getChild(paramModel.getName()).ifPresent(generationInfoBuilder::withSyntax);
        }
        parameterAsts.put(new Pair<ParameterModel, ParameterGroupModel>(paramModel, pg), new DefaultComponentParameterAst(errorMappings.isEmpty() ? null : errorMappings, paramModel, pg, generationInfoBuilder.build(), this.propertiesResolver));
    }

    private void populateParameterAst(Map<Pair<ParameterModel, ParameterGroupModel>, ComponentParameterAst> parameterAsts, Optional<String> rawValue, ParameterGroupModel pg, ParameterModel paramModel) {
        if (!this.parameterNames.contains(paramModel.getName())) {
            DefaultComponentGenerationInformation.Builder generationInfoBuilder = DefaultComponentGenerationInformation.builder();
            DslElementSyntax syntax = this.generationInformationBuilder.getSyntax();
            if (syntax != null) {
                if (pg.isShowInDsl()) {
                    syntax = syntax.getChild(pg.getName()).orElse(syntax);
                }
                syntax.getContainedElement(paramModel.getName()).ifPresent(generationInfoBuilder::withSyntax);
            }
            ComponentGenerationInformation generationInfo = generationInfoBuilder.build();
            parameterAsts.put(new Pair<ParameterModel, ParameterGroupModel>(paramModel, pg), rawValue.map(rawParamValue -> new DefaultComponentParameterAst((String)rawParamValue, paramModel, pg, generationInfo, this.propertiesResolver)).orElseGet(() -> new DefaultComponentParameterAst((String)null, paramModel, pg, generationInfo, this.propertiesResolver)));
        }
    }

    public Map<String, Object> getAnnotations() {
        return this.annotations;
    }

    public ComponentAstBuilder withExtensionModel(ExtensionModel extensionModel) {
        this.extensionModel = extensionModel;
        return this;
    }

    public ExtensionModel getExtensionModel() {
        return this.extensionModel;
    }

    public ComponentAstBuilder withComponentModel(ComponentModel componentModel) {
        this.validateSingleModelSet();
        this.componentModel = componentModel;
        return this;
    }

    public ComponentAstBuilder withNestableElementModel(NestableElementModel nestableElementModel) {
        this.validateSingleModelSet();
        this.nestableElementModel = nestableElementModel;
        return this;
    }

    public ComponentAstBuilder withConfigurationModel(ConfigurationModel configurationModel) {
        this.validateSingleModelSet();
        this.configurationModel = configurationModel;
        return this;
    }

    public ComponentAstBuilder withConnectionProviderModel(ConnectionProviderModel connectionProviderModel) {
        this.validateSingleModelSet();
        this.connectionProviderModel = connectionProviderModel;
        return this;
    }

    @Override
    public BaseComponentAstBuilder<B> withParameterizedModel(ParameterizedModel parameterizedModel) {
        this.validateSingleModelSet();
        this.parameterizedModel = parameterizedModel;
        if (parameterizedModel instanceof MetadataTypeAdapter) {
            this.type = ((MetadataTypeAdapter)((Object)parameterizedModel)).getType();
        }
        return this;
    }

    protected void validateSingleModelSet() {
        this.getModel(Object.class).ifPresent(model -> {
            throw new IllegalStateException("Model previously set: " + model);
        });
    }

    public <M> Optional<M> getModel(Class<M> modelClass) {
        if (this.componentModel != null && modelClass.isInstance(this.componentModel)) {
            return Optional.of(this.componentModel);
        }
        if (this.configurationModel != null && modelClass.isInstance(this.configurationModel)) {
            return Optional.of(this.configurationModel);
        }
        if (this.connectionProviderModel != null && modelClass.isInstance(this.connectionProviderModel)) {
            return Optional.of(this.connectionProviderModel);
        }
        if (this.nestableElementModel != null && modelClass.isInstance(this.nestableElementModel)) {
            return Optional.of(this.nestableElementModel);
        }
        if (this.parameterizedModel != null && modelClass.isInstance(this.parameterizedModel)) {
            return Optional.of(this.parameterizedModel);
        }
        return Optional.empty();
    }

    public MetadataType getType() {
        return this.type;
    }

    @Override
    public ComponentAstBuilder withMetadata(ComponentMetadataAst metadata) {
        this.metadata = metadata;
        return this;
    }

    public ComponentMetadataAst getMetadata() {
        return this.metadata;
    }

    public ComponentAstBuilder withLocation(ComponentLocation location) {
        this.location = location;
        return this;
    }

    public ComponentAstBuilder withComponentType(TypedComponentIdentifier.ComponentType componentType) {
        this.componentType = componentType;
        return this;
    }

    public TypedComponentIdentifier.ComponentType getComponentType() {
        return this.componentType;
    }

    @Override
    public ComponentAstBuilder withIdentifier(ComponentIdentifier identifier) {
        this.identifier = identifier;
        return this;
    }

    public ComponentIdentifier getIdentifier() {
        return this.identifier;
    }

    public ComponentLocation getLocation() {
        return this.location;
    }

    public DefaultComponentGenerationInformation.Builder getGenerationInformation() {
        return this.generationInformationBuilder;
    }

    public Stream<B> childComponentsStream() {
        return this.childComponents.stream();
    }

    protected Set<B> getParamsChildren() {
        return this.paramsChildren;
    }

    protected Optional<String> resolveComponentId(Map<Pair<ParameterModel, ParameterGroupModel>, ComponentParameterAst> parameterAsts) {
        Optional<String> compIdFromParams = this.getModel(ParameterizedModel.class).flatMap(paramzdModel -> paramzdModel.getAllParameterModels().stream().filter(ParameterModel::isComponentId).findAny().flatMap(paramModel -> {
            if (this.getIdentifier().equals(ERROR_HANDLER_IDENTIFIER) && parameterAsts.entrySet().stream().anyMatch(e -> ((ParameterModel)((Pair)e.getKey()).getFirst()).getName().equals("ref") && ((ComponentParameterAst)e.getValue()).getValue().getValue().isPresent())) {
                return Optional.empty();
            }
            ComponentParameterAst componentParameterAst = parameterAsts.entrySet().stream().filter(f -> ((ParameterModel)((Pair)f.getKey()).getFirst()).equals(paramModel)).findAny().map(Map.Entry::getValue).orElse(null);
            if (componentParameterAst != null) {
                return Optional.ofNullable(componentParameterAst.getRawValue());
            }
            return Optional.empty();
        }));
        if (!compIdFromParams.isPresent() && this.getModel(HasStereotypeModel.class).map(hsm -> MuleStereotypes.APP_CONFIG.equals(hsm.getStereotype())).orElse(false).booleanValue()) {
            return this.getModel(NamedObject.class).map(no -> "_mule" + StringUtils.capitalize((String)no.getName()));
        }
        return compIdFromParams;
    }

    public void setComponentId(Supplier<Optional<String>> componentId) {
        this.componentId = componentId;
    }

    public Optional<String> getComponentId() {
        try {
            return this.componentId.get().map(this.propertiesResolver);
        }
        catch (PropertyNotFoundException e) {
            return this.componentId.get();
        }
    }

    protected PropertiesResolver getPropertiesResolver() {
        return this.propertiesResolver;
    }
}

