/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.error.matcher.ErrorTypeMatcher;
import org.mule.runtime.api.message.error.matcher.ErrorTypeMatcherUtils;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.config.internal.error.MuleCoreErrorTypeRepository;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.privileged.exception.DefaultExceptionListener;
import org.mule.runtime.core.privileged.exception.MessagingExceptionHandlerAcceptor;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class OnCriticalErrorHandler
implements MessagingExceptionHandlerAcceptor {
    private static final Logger logger = LoggerFactory.getLogger(OnCriticalErrorHandler.class);
    private final ErrorTypeMatcher criticalMatcher = ErrorTypeMatcherUtils.createErrorTypeMatcher(MuleCoreErrorTypeRepository.CRITICAL_ERROR_TYPE);
    private final ErrorTypeMatcher overloadMatcher;
    @Inject
    private NotificationDispatcher notificationFirer;
    private final DefaultExceptionListener exceptionListener;

    public OnCriticalErrorHandler(ErrorTypeMatcher overloadMatcher) {
        this.overloadMatcher = overloadMatcher;
        this.exceptionListener = new DefaultExceptionListener();
        this.exceptionListener.setNotificationFirer(this.notificationFirer);
        this.exceptionListener.setRepresentation(this.toString());
    }

    @Override
    public boolean accept(CoreEvent event) {
        Optional<Error> error = event.getError();
        return error.isPresent() && this.criticalMatcher.match(error.get().getErrorType());
    }

    @Override
    public boolean acceptsAll() {
        return false;
    }

    @Override
    public CoreEvent handleException(Exception exception, CoreEvent event) {
        this.logException(exception);
        return event;
    }

    @Override
    public Publisher<CoreEvent> apply(Exception exception) {
        this.logException(exception);
        return Mono.error((Throwable)exception);
    }

    public void logException(Throwable exception) {
        ErrorType errorType;
        if (exception instanceof MessagingException && ((MessagingException)exception).getEvent().getError().isPresent() && this.overloadMatcher.match(errorType = ((MessagingException)exception).getEvent().getError().get().getErrorType())) {
            if (logger.isInfoEnabled()) {
                logger.info(this.exceptionListener.resolveExceptionAndMessageToLog(exception).toString());
            }
            return;
        }
        this.exceptionListener.resolveAndLogException(exception);
    }

    @Override
    public Consumer<Exception> router(Function<Publisher<CoreEvent>, Publisher<CoreEvent>> publisherPostProcessor, Consumer<CoreEvent> continueCallback, Consumer<Throwable> propagateCallback) {
        return error -> {
            this.logException((Throwable)error);
            propagateCallback.accept((Throwable)error);
        };
    }

    public String toString() {
        return "OnCriticalErrorHandler";
    }

    public DefaultExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }
}

