/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.ast;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DirectedMultigraph;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.BaseComponentAstDecorator;
import org.mule.runtime.ast.api.util.MuleArtifactAstCopyUtils;
import org.mule.runtime.extension.api.property.XmlExtensionModelProperty;
import org.mule.runtime.extension.internal.ast.MacroExpansionModuleModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroExpansionModulesModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MacroExpansionModulesModel.class);
    private static final String FILE_MACRO_EXPANSION_DELIMITER = StringUtils.repeat((char)'*', (int)80) + System.lineSeparator();
    private static final String FILE_MACRO_EXPANSION_SECTION_DELIMITER = StringUtils.repeat((char)'-', (int)80) + System.lineSeparator();
    private static final String FLOW_ELEMENT = "flow";
    private static final String SUB_FLOW_ELEMENT = "sub-flow";
    private static final ComponentIdentifier FLOW_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("flow").build();
    private static final ComponentIdentifier SUB_FLOW_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("sub-flow").build();
    private ArtifactAst applicationModel;
    private final List<ExtensionModel> sortedExtensions;
    private final Optional<FeatureFlaggingService> featureFlaggingService;

    public MacroExpansionModulesModel(ArtifactAst applicationModel, Set<ExtensionModel> extensions, Optional<FeatureFlaggingService> featureFlaggingService) {
        this.applicationModel = applicationModel;
        this.sortedExtensions = this.calculateExtensionByTopologicalOrder(extensions);
        this.featureFlaggingService = featureFlaggingService;
    }

    public ArtifactAst expand() {
        boolean hasMacroExpansionExtension = false;
        for (ExtensionModel extensionModel : this.sortedExtensions) {
            if (!extensionModel.getModelProperty(XmlExtensionModelProperty.class).isPresent()) continue;
            hasMacroExpansionExtension = true;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("macro expanding '%s' connector, xmlns:%s=\"%s\"", extensionModel.getName(), extensionModel.getXmlDslModel().getPrefix(), extensionModel.getXmlDslModel().getNamespace()));
            }
            this.applicationModel = new MacroExpansionModuleModel(this.applicationModel, extensionModel, this.featureFlaggingService).expand();
        }
        if (hasMacroExpansionExtension) {
            List componentsToAdd = this.applicationModel.recursiveStream().filter(c -> this.isFlow((ComponentAst)c) || this.isSubFlow((ComponentAst)c)).filter(comp -> !this.applicationModel.topLevelComponents().contains(comp)).collect(Collectors.toList());
            this.applicationModel = MuleArtifactAstCopyUtils.copyRecursively(this.applicationModel, comp -> {
                final List childrenToKeep = comp.directChildrenStream().filter(child -> componentsToAdd.stream().noneMatch(c -> c.getIdentifier().equals(child.getIdentifier()))).collect(Collectors.toList());
                return new BaseComponentAstDecorator((ComponentAst)comp){

                    @Override
                    public List<ComponentAst> directChildren() {
                        return childrenToKeep;
                    }

                    @Override
                    public Stream<ComponentAst> directChildrenStream() {
                        return childrenToKeep.stream();
                    }
                };
            }, () -> componentsToAdd, c -> false);
            if (LOGGER.isDebugEnabled()) {
                StringBuilder buf = new StringBuilder(1024);
                buf.append(System.lineSeparator()).append(FILE_MACRO_EXPANSION_DELIMITER);
                AtomicReference lastFile = new AtomicReference();
                this.applicationModel.topLevelComponentsStream().forEach(comp -> {
                    String fileName = comp.getMetadata().getFileName().orElse("<unnamed>");
                    if (!fileName.equals(lastFile.get())) {
                        if (lastFile.get() != null) {
                            buf.append(System.lineSeparator()).append(FILE_MACRO_EXPANSION_SECTION_DELIMITER);
                        }
                        buf.append("Filename: ").append(fileName);
                        buf.append(System.lineSeparator()).append(FILE_MACRO_EXPANSION_SECTION_DELIMITER);
                        lastFile.set(fileName);
                    }
                    buf.append(comp.getMetadata().getSourceCode().orElse("")).append(System.lineSeparator());
                });
                buf.append(System.lineSeparator()).append(FILE_MACRO_EXPANSION_DELIMITER);
                LOGGER.debug(buf.toString());
            }
        }
        return this.applicationModel;
    }

    private List<ExtensionModel> calculateExtensionByTopologicalOrder(Set<ExtensionModel> extensions) {
        Set<String> extensionsUsedInApp;
        ArrayList<ExtensionModel> result = new ArrayList<ExtensionModel>();
        Map allExtensionsByNamespace = extensions.stream().filter(extensionModel -> extensionModel.getModelProperty(XmlExtensionModelProperty.class).isPresent()).collect(Collectors.toMap(extModel -> extModel.getXmlDslModel().getNamespace(), Function.identity()));
        if (!allExtensionsByNamespace.isEmpty() && !(extensionsUsedInApp = this.applicationModel.recursiveStream().map(comp -> comp.getIdentifier().getNamespaceUri()).filter(ns -> allExtensionsByNamespace.keySet().contains(ns)).collect(Collectors.toSet())).isEmpty()) {
            DirectedMultigraph namespaceDAG = new DirectedMultigraph(DefaultEdge.class);
            extensionsUsedInApp.forEach(arg_0 -> this.lambda$calculateExtensionByTopologicalOrder$12((Graph)namespaceDAG, allExtensionsByNamespace, arg_0));
            TopologicalOrderIterator graphIterator = new TopologicalOrderIterator((Graph)namespaceDAG);
            while (graphIterator.hasNext()) {
                String namespace = (String)graphIterator.next();
                if (!allExtensionsByNamespace.containsKey(namespace)) continue;
                result.add((ExtensionModel)allExtensionsByNamespace.get(namespace));
            }
        }
        return result;
    }

    private void fillDependencyGraph(Graph<String, DefaultEdge> g, String sourceVertex, Map<String, ExtensionModel> allExtensionsByNamespace) {
        ExtensionModel extensionModel = allExtensionsByNamespace.get(sourceVertex);
        g.addVertex((Object)sourceVertex);
        for (String dependencyNamespace : this.getDependenciesOrFail(extensionModel)) {
            if (!allExtensionsByNamespace.containsKey(dependencyNamespace)) continue;
            g.addVertex((Object)dependencyNamespace);
            g.addEdge((Object)sourceVertex, (Object)dependencyNamespace);
            this.fillDependencyGraph(g, dependencyNamespace, allExtensionsByNamespace);
        }
    }

    private Set<String> getDependenciesOrFail(ExtensionModel extensionModel) {
        return extensionModel.getModelProperty(XmlExtensionModelProperty.class).orElseThrow(() -> new IllegalArgumentException(String.format("The current extension [%s] (namespace [%s]) does not have the macro expansion model property, it should have never reach here.", extensionModel.getName(), extensionModel.getXmlDslModel().getNamespace()))).getNamespacesDependencies();
    }

    private boolean isFlow(ComponentAst component) {
        return FLOW_IDENTIFIER.equals(component.getIdentifier()) && TypedComponentIdentifier.ComponentType.FLOW.equals((Object)component.getComponentType());
    }

    private boolean isSubFlow(ComponentAst component) {
        return SUB_FLOW_IDENTIFIER.equals(component.getIdentifier()) && TypedComponentIdentifier.ComponentType.SCOPE.equals((Object)component.getComponentType());
    }

    private /* synthetic */ void lambda$calculateExtensionByTopologicalOrder$12(Graph namespaceDAG, Map allExtensionsByNamespace, String namespace) {
        this.fillDependencyGraph((Graph<String, DefaultEdge>)namespaceDAG, namespace, allExtensionsByNamespace);
    }
}

