/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.enricher;

import com.google.common.base.Joiner;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.extension.api.exception.IllegalConfigurationModelDefinitionException;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.IdempotentDeclarationEnricherWalkDelegate;
import org.mule.runtime.extension.api.loader.WalkingDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.reflections.ReflectionUtils;

public abstract class AbstractAnnotatedFieldDeclarationEnricher
implements WalkingDeclarationEnricher {
    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.POST_STRUCTURE;
    }

    @Override
    public Optional<WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate> getWalkDelegate(ExtensionLoadingContext extensionLoadingContext) {
        Predicate<Field> fieldHasAnnotationPredicate = this.getFieldHasAnnotationPredicate();
        return Optional.of(this.getWalkDelegate(fieldHasAnnotationPredicate));
    }

    protected WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate getWalkDelegate(final Predicate<Field> fieldHasAnnotationPredicate) {
        return new IdempotentDeclarationEnricherWalkDelegate(){

            @Override
            public void onConfiguration(ConfigurationDeclaration declaration) {
                AbstractAnnotatedFieldDeclarationEnricher.this.doEnrich(declaration, fieldHasAnnotationPredicate);
            }

            @Override
            protected void onConnectionProvider(ConnectionProviderDeclaration declaration) {
                AbstractAnnotatedFieldDeclarationEnricher.this.doEnrich(declaration, fieldHasAnnotationPredicate);
            }

            @Override
            protected void onSource(SourceDeclaration declaration) {
                AbstractAnnotatedFieldDeclarationEnricher.this.doEnrich(declaration, fieldHasAnnotationPredicate);
            }
        };
    }

    protected void doEnrich(BaseDeclaration<?> declaration, Predicate<Field> fieldHasAnnotationPredicate) {
        Class implementingType = this.getImplementingClass();
        declaration.getModelProperty(ImplementingTypeModelProperty.class).ifPresent(typeProperty -> {
            Set fields = ReflectionUtils.getAllFields(typeProperty.getType(), (Predicate[])new Predicate[]{fieldHasAnnotationPredicate});
            if (fields.isEmpty()) {
                return;
            }
            this.validate(fields, (ImplementingTypeModelProperty)typeProperty, this.getAnnotationName(), implementingType);
            declaration.addModelProperty(this.getModelProperty((Field)fields.iterator().next()));
        });
    }

    protected void validate(Collection<Field> fields, ImplementingTypeModelProperty typeProperty, String annotationName, Class implementingClass) {
        if (fields.size() > 1) {
            throw new IllegalConfigurationModelDefinitionException(String.format("Only one field is allowed to be annotatedwith @%s, but class '%s' has %d fields with such annotation. Offending fields are: [%s]", annotationName, typeProperty.getType().getName(), fields.size(), Joiner.on((String)", ").join((Iterable)fields.stream().map(Field::getName).collect(Collectors.toList()))));
        }
        Field field = fields.iterator().next();
        if (!implementingClass.equals(field.getType())) {
            throw new IllegalConfigurationModelDefinitionException(String.format("Class '%s' declares the field '%s' which isannotated with @%s and is of type '%s'. Only fields of type %s are allowed to carry suchannotation", typeProperty.getType().getName(), field.getName(), annotationName, field.getType().getName(), implementingClass));
        }
    }

    protected abstract ModelProperty getModelProperty(Field var1);

    protected abstract Predicate<Field> getFieldHasAnnotationPredicate();

    protected abstract String getAnnotationName();

    protected abstract Class getImplementingClass();
}

