/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.api.loader.java.type.WithAnnotations;
import org.mule.runtime.module.extension.internal.loader.parser.AttributesResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.ParameterGroupModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.ParameterModelParserDecorator;
import org.mule.runtime.module.extension.internal.loader.parser.java.HasExtensionParameter;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaOperationModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaSourceModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.metadata.JavaMetadataKeyModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.metadata.InputResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.metadata.MetadataKeyModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.metadata.OutputResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.utils.JavaMetadataTypeResolverUtils;
import org.mule.sdk.api.annotation.metadata.MetadataKeyId;
import org.mule.sdk.api.annotation.metadata.MetadataKeyPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaMetadataKeyIdModelParserUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaMetadataKeyIdModelParserUtils.class);

    public static Optional<MetadataKeyModelParser> parseKeyIdResolverModelParser(ExtensionParameter extensionParameter, String categoryName, String groupName) {
        String parameterName = !StringUtils.isBlank(groupName) ? groupName : extensionParameter.getName();
        MetadataType metadataType = extensionParameter.getType().asMetadataType();
        return MuleExtensionAnnotationParser.mapReduceSingleAnnotation(extensionParameter, "parameter", extensionParameter.getName(), org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId.class, MetadataKeyId.class, valueFetcher -> {
            Type type = valueFetcher.getClassValue(org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId::value);
            return type.getDeclaringClass().map(value -> JavaMetadataKeyIdModelParserUtils.keyIdResolverFromType(parameterName, categoryName, metadataType, value)).orElse(null);
        }, valueFetcher -> {
            Type type = valueFetcher.getClassValue(MetadataKeyId::value);
            return type.getDeclaringClass().map(value -> JavaMetadataKeyIdModelParserUtils.keyIdResolverFromType(parameterName, categoryName, metadataType, value)).orElse(null);
        });
    }

    public static Optional<MetadataKeyModelParser> parseKeyIdResolverModelParser(Type extensionType, WithAnnotations annotatedType, String elementType, String elementName, String extensionName) {
        Optional<MetadataKeyModelParser> keyIdResolverModelParser = JavaMetadataKeyIdModelParserUtils.parseKeyIdResolverModelParser(annotatedType, elementType, elementName);
        if (!keyIdResolverModelParser.isPresent()) {
            keyIdResolverModelParser = JavaMetadataKeyIdModelParserUtils.parseKeyIdResolverModelParser(extensionType, "extension", extensionName);
        }
        return keyIdResolverModelParser;
    }

    public static Optional<MetadataKeyModelParser> parseKeyIdResolverModelParser(WithAnnotations annotatedType, String elementType, String elementName) {
        return MuleExtensionAnnotationParser.mapReduceSingleAnnotation(annotatedType, elementType, elementName, MetadataScope.class, org.mule.sdk.api.annotation.metadata.MetadataScope.class, valueFetcher -> {
            Type type = valueFetcher.getClassValue(MetadataScope::keysResolver);
            return type.getDeclaringClass().map(JavaMetadataKeyIdModelParserUtils::keyIdResolverFromTypeOnSources).orElse(null);
        }, valueFetcher -> {
            Type type = valueFetcher.getClassValue(org.mule.sdk.api.annotation.metadata.MetadataScope::keysResolver);
            return type.getDeclaringClass().map(JavaMetadataKeyIdModelParserUtils::keyIdResolverFromTypeOnSources).orElse(null);
        });
    }

    public static Optional<Pair<Integer, Boolean>> getMetadataKeyPart(ExtensionParameter extensionParameter) {
        return MuleExtensionAnnotationParser.mapReduceSingleAnnotation(extensionParameter, "parameter", extensionParameter.getName(), org.mule.runtime.extension.api.annotation.metadata.MetadataKeyPart.class, MetadataKeyPart.class, value -> new Pair<Integer, Boolean>(value.getNumberValue(org.mule.runtime.extension.api.annotation.metadata.MetadataKeyPart::order), value.getBooleanValue(org.mule.runtime.extension.api.annotation.metadata.MetadataKeyPart::providedByKeyResolver)), value -> new Pair<Integer, Boolean>(value.getNumberValue(MetadataKeyPart::order), value.getBooleanValue(MetadataKeyPart::providedByKeyResolver)));
    }

    private static JavaMetadataKeyModelParser keyIdResolverFromType(String parameterName, String categoryName, MetadataType metadataType, Class<?> clazz) {
        if (!JavaMetadataTypeResolverUtils.isStaticResolver(clazz)) {
            return new JavaMetadataKeyModelParser(parameterName, categoryName, metadataType, clazz);
        }
        return null;
    }

    private static JavaMetadataKeyModelParser keyIdResolverFromTypeOnSources(Class<?> clazz) {
        if (!JavaMetadataTypeResolverUtils.isStaticResolver(clazz)) {
            return new JavaMetadataKeyModelParser(null, null, null, clazz);
        }
        return null;
    }

    public static Optional<MetadataKeyModelParser> getKeyIdResolverModelParser(JavaOperationModelParser javaOperationModelParser, WithAnnotations operationType, ExtensionElement extensionElement) {
        return JavaMetadataKeyIdModelParserUtils.getKeyIdResolverModelParser(javaOperationModelParser.getOutputResolverModelParser().orElse(null), javaOperationModelParser.getAttributesResolverModelParser().orElse(null), javaOperationModelParser.getInputResolverModelParsers(), javaOperationModelParser.getParameterGroupModelParsers(), operationType, extensionElement, javaOperationModelParser.getName(), "operation");
    }

    public static Optional<MetadataKeyModelParser> getKeyIdResolverModelParser(JavaSourceModelParser javaSourceModelParser, WithAnnotations sourceType, ExtensionElement extensionElement) {
        return JavaMetadataKeyIdModelParserUtils.getKeyIdResolverModelParser(javaSourceModelParser.getOutputResolverModelParser().orElse(null), javaSourceModelParser.getAttributesResolverModelParser().orElse(null), Collections.emptyList(), javaSourceModelParser.getParameterGroupModelParsers(), sourceType, extensionElement, javaSourceModelParser.getName(), "source");
    }

    private static Optional<MetadataKeyModelParser> getKeyIdResolverModelParser(OutputResolverModelParser outputResolverModelParser, AttributesResolverModelParser attributesResolverModelParser, List<InputResolverModelParser> inputResolverModelParsers, List<ParameterGroupModelParser> parameterGroupModelParsers, WithAnnotations componentType, ExtensionElement extensionElement, String elementName, String elementType) {
        Optional<MetadataKeyModelParser> enclosingKeyIdResolverModelParser;
        if (outputResolverModelParser == null && inputResolverModelParsers.isEmpty() && SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17)) {
            return Optional.empty();
        }
        String categoryName = JavaMetadataKeyIdModelParserUtils.getCategoryName(outputResolverModelParser, attributesResolverModelParser, inputResolverModelParsers);
        Optional<Object> keyIdResolverModelParser = parameterGroupModelParsers.stream().map(parameterGroupModelParser -> {
            if (parameterGroupModelParser instanceof HasExtensionParameter) {
                return JavaMetadataKeyIdModelParserUtils.parseKeyIdResolverModelParser(((HasExtensionParameter)((Object)parameterGroupModelParser)).getExtensionParameter(), categoryName, parameterGroupModelParser.getName());
            }
            return Optional.empty();
        }).filter(Optional::isPresent).map(Optional::get).findFirst();
        if (!keyIdResolverModelParser.isPresent()) {
            keyIdResolverModelParser = parameterGroupModelParsers.stream().map(ParameterGroupModelParser::getParameterParsers).flatMap(Collection::stream).map(parameterModelParser -> {
                if (parameterModelParser instanceof ParameterModelParserDecorator) {
                    parameterModelParser = ((ParameterModelParserDecorator)parameterModelParser).getDecoratee();
                }
                if (parameterModelParser instanceof HasExtensionParameter) {
                    return JavaMetadataKeyIdModelParserUtils.parseKeyIdResolverModelParser(((HasExtensionParameter)((Object)parameterModelParser)).getExtensionParameter(), categoryName, null);
                }
                return Optional.empty();
            }).filter(Optional::isPresent).map(Optional::get).findFirst();
        }
        if (keyIdResolverModelParser.isPresent() && !((MetadataKeyModelParser)keyIdResolverModelParser.get()).hasKeyIdResolver() && (enclosingKeyIdResolverModelParser = JavaMetadataKeyIdModelParserUtils.parseKeyIdResolverModelParser(extensionElement, componentType, elementType, elementName, extensionElement.getName())).isPresent()) {
            keyIdResolverModelParser = Optional.of(new JavaMetadataKeyModelParser(((MetadataKeyModelParser)keyIdResolverModelParser.get()).getParameterName(), categoryName, ((MetadataKeyModelParser)keyIdResolverModelParser.get()).getMetadataType(), ((JavaMetadataKeyModelParser)enclosingKeyIdResolverModelParser.get()).keyIdResolverDeclarationClass()));
        }
        return keyIdResolverModelParser;
    }

    private static String getCategoryName(OutputResolverModelParser outputResolverModelParser, AttributesResolverModelParser attributesResolverModelParser, List<InputResolverModelParser> inputResolverModelParsers) {
        if (outputResolverModelParser != null) {
            return outputResolverModelParser.getOutputResolver().getCategoryName();
        }
        if (attributesResolverModelParser != null) {
            return attributesResolverModelParser.getAttributesResolver().getCategoryName();
        }
        Iterator<InputResolverModelParser> iterator = inputResolverModelParsers.iterator();
        if (iterator.hasNext()) {
            InputResolverModelParser inputResolverModelParser = iterator.next();
            return inputResolverModelParser.getInputResolver().getCategoryName();
        }
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17)) {
            throw new IllegalModelDefinitionException("Unable to create Keys Resolver. A Keys Resolver is being defined without defining an Output Resolver, Input Resolver nor Attributes Resolver");
        }
        LOGGER.warn("A Keys Resolver is being defined without defining an Output Resolver, Input Resolver nor Attributes Resolver");
        return null;
    }
}

