/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.utils;

import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSemanticTermsDeclaration;
import org.mule.runtime.api.metadata.resolving.NamedTypeResolver;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.util.XmlModelUtils;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.api.metadata.ComponentMetadataConfigurer;
import org.mule.runtime.module.extension.internal.loader.parser.AttributesResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.SemanticTermsParser;
import org.mule.runtime.module.extension.internal.loader.parser.XmlDslConfiguration;
import org.mule.runtime.module.extension.internal.loader.parser.metadata.InputResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.metadata.MetadataKeyModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.metadata.OutputResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.metadata.RoutesChainInputTypesResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.metadata.ScopeChainInputTypeResolverModelParser;
import org.mule.sdk.api.metadata.NullMetadataResolver;

public final class ModelLoaderUtils {
    private ModelLoaderUtils() {
    }

    public static void addSemanticTerms(WithSemanticTermsDeclaration declaration, SemanticTermsParser parser) {
        declaration.getSemanticTerms().addAll(parser.getSemanticTerms());
    }

    public static XmlDslModel getXmlDslModel(String extensionName, String version, Optional<XmlDslConfiguration> xmlDslAnnotationConfiguration) {
        Optional<String> prefix = Optional.empty();
        Optional<String> namespace = Optional.empty();
        if (xmlDslAnnotationConfiguration.isPresent()) {
            prefix = Optional.of(xmlDslAnnotationConfiguration.get().getPrefix());
            namespace = Optional.of(xmlDslAnnotationConfiguration.get().getNamespace());
        }
        return XmlModelUtils.createXmlLanguageModel(prefix, namespace, extensionName, version);
    }

    public static XmlDslModel getXmlDslModel(ExtensionElement extensionElement, String version, Optional<XmlDslConfiguration> xmlDslAnnotationConfiguration) {
        return ModelLoaderUtils.getXmlDslModel(extensionElement.getName(), version, xmlDslAnnotationConfiguration);
    }

    public static void declareMetadataModelProperties(ParameterizedDeclaration declaration, Optional<OutputResolverModelParser> outputResolverModelParser, Optional<AttributesResolverModelParser> attributesResolverModelParser, List<InputResolverModelParser> inputResolverModelParsers, Optional<MetadataKeyModelParser> keyIdResolverModelParser, boolean connected) {
        ModelLoaderUtils.declareMetadataModelProperties(declaration, outputResolverModelParser, attributesResolverModelParser, inputResolverModelParsers, keyIdResolverModelParser, connected, Optional.empty(), Optional.empty());
    }

    public static void declareMetadataModelProperties(ParameterizedDeclaration declaration, Optional<OutputResolverModelParser> outputResolverModelParser, Optional<AttributesResolverModelParser> attributesResolverModelParser, List<InputResolverModelParser> inputResolverModelParsers, Optional<MetadataKeyModelParser> keyIdResolverModelParser, boolean connected, Optional<ScopeChainInputTypeResolverModelParser> scopeChainInputResolverParser, Optional<RoutesChainInputTypesResolverModelParser> routesChainInputTypesResolverParser) {
        if (outputResolverModelParser.map(p -> p.hasOutputResolver()).orElse(false).booleanValue() || !inputResolverModelParsers.isEmpty() || keyIdResolverModelParser.map(p -> p.hasKeyIdResolver()).orElse(false).booleanValue()) {
            ComponentMetadataConfigurer configurer = new ComponentMetadataConfigurer().setConnected(connected);
            outputResolverModelParser.ifPresent(p -> configurer.setOutputTypeResolver(p.getOutputResolver()));
            attributesResolverModelParser.ifPresent(p -> configurer.setAttributesTypeResolver(p.getAttributesResolver()));
            keyIdResolverModelParser.ifPresent(p -> configurer.setKeysResolver(p.getKeyResolver(), p.getParameterName(), p.getMetadataType(), p.isPartialKeyResolver()));
            inputResolverModelParsers.forEach(parser -> configurer.addInputResolver(parser.getParameterName(), parser.getInputResolver()));
            scopeChainInputResolverParser.ifPresent(p -> configurer.setChainInputTypeResolver(p.getChainInputTypeResolver()));
            routesChainInputTypesResolverParser.ifPresent(p -> configurer.addRoutesChainInputResolvers(p.getRoutesChainInputResolvers()));
            configurer.configure(declaration);
        } else {
            ComponentMetadataConfigurer.configureNullMetadata(declaration);
        }
    }

    public static String getCategoryName(MetadataKeyModelParser metadataKeyModelParser, List<InputResolverModelParser> inputResolverModelParsers, OutputResolverModelParser outputResolverModelParser) {
        if (metadataKeyModelParser != null && metadataKeyModelParser.hasKeyIdResolver()) {
            return metadataKeyModelParser.getKeyResolver().getCategoryName();
        }
        if (!inputResolverModelParsers.isEmpty()) {
            return inputResolverModelParsers.iterator().next().getInputResolver().getCategoryName();
        }
        if (outputResolverModelParser != null && outputResolverModelParser.hasOutputResolver()) {
            return outputResolverModelParser.getOutputResolver().getCategoryName();
        }
        return null;
    }

    public static String getCategoryName(TypeKeysResolver typeKeysResolver, String firstSeenInputResolverCategory, OutputTypeResolver outputTypeResolver) {
        if (ModelLoaderUtils.isNotNull(typeKeysResolver)) {
            return typeKeysResolver.getCategoryName();
        }
        if (!StringUtils.isBlank(firstSeenInputResolverCategory)) {
            return firstSeenInputResolverCategory;
        }
        if (ModelLoaderUtils.isNotNull(outputTypeResolver)) {
            return outputTypeResolver.getCategoryName();
        }
        return null;
    }

    private static boolean isNotNull(Object resolver) {
        if (resolver == null) {
            return false;
        }
        if (resolver instanceof NamedTypeResolver) {
            return !(resolver instanceof org.mule.runtime.extension.api.metadata.NullMetadataResolver);
        }
        if (resolver instanceof org.mule.sdk.api.metadata.resolving.NamedTypeResolver) {
            return !(resolver instanceof NullMetadataResolver);
        }
        return true;
    }
}

