/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.metadata.chain;

import java.util.Optional;
import java.util.function.Function;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.AttributesTypeResolver;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;

public class PassThroughChainOutputTypeResolver
implements OutputTypeResolver<Void>,
AttributesTypeResolver<Void> {
    public static final PassThroughChainOutputTypeResolver INSTANCE = new PassThroughChainOutputTypeResolver();

    private PassThroughChainOutputTypeResolver() {
    }

    @Override
    public String getCategoryName() {
        return "SCOPE_PASSTHROUGH";
    }

    @Override
    public String getResolverName() {
        return "SCOPE_OUTPUT_PASSTHROUGH";
    }

    @Override
    public MetadataType getOutputType(MetadataContext context, Void key) throws MetadataResolvingException, ConnectionException {
        return this.passthrough(context, MessageMetadataType::getPayloadType).orElseThrow(() -> new MetadataResolvingException("Resolved output payload not found.", FailureCode.UNKNOWN));
    }

    @Override
    public MetadataType getAttributesType(MetadataContext context, Void key) throws MetadataResolvingException, ConnectionException {
        return this.passthrough(context, MessageMetadataType::getAttributesType).orElseThrow(() -> new MetadataResolvingException("Resolved output attributes not found.", FailureCode.UNKNOWN));
    }

    private Optional<MetadataType> passthrough(MetadataContext context, Function<MessageMetadataType, Optional<MetadataType>> extractor) {
        return context.getScopeOutputMetadataContext().flatMap(ctx -> (Optional)extractor.apply(ctx.getInnerChainOutputMessageType().get()));
    }
}

