/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.exception;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.exception.TypedException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.internal.util.ExtensionNamespaceUtils;
import org.mule.runtime.module.extension.internal.error.SdkErrorTypeDefinitionAdapter;
import org.mule.sdk.api.exception.ModuleException;

public class ModuleExceptionHandler {
    private final Set<ErrorModel> allowedErrorTypes;
    private final String extensionNamespace;
    private final boolean suppressErrors;
    private final LoadingCache<org.mule.sdk.api.error.ErrorTypeDefinition, Function<Throwable, ErrorType>> errorTypeCache;

    public ModuleExceptionHandler(ComponentModel componentModel, ExtensionModel extensionModel, ErrorTypeRepository typeRepository, boolean suppressErrors) {
        this.allowedErrorTypes = componentModel.getErrorModels();
        this.extensionNamespace = ExtensionNamespaceUtils.getExtensionsNamespace(extensionModel);
        this.suppressErrors = suppressErrors;
        this.errorTypeCache = Caffeine.newBuilder().build(errorDefinition -> {
            Optional<ErrorType> errorTypeLookedUp = typeRepository.lookupErrorType(ComponentIdentifier.builder().namespace(this.extensionNamespace).name(errorDefinition.getType()).build());
            if (errorTypeLookedUp.isPresent()) {
                ErrorType errorType = errorTypeLookedUp.get();
                if (this.isAllowedError(errorType)) {
                    return exception -> errorType;
                }
                return exception -> {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("The component '%s' from the connector '%s' attempted to throw '%s', but only %s errors are allowed.", componentModel.getName(), extensionModel.getName(), this.extensionNamespace + ":" + errorDefinition, this.allowedErrorTypes), exception.getCause());
                };
            }
            return exception -> {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("The component '%s' from the connector '%s' attempted to throw '%s', but it was not registered in the Error Repository", componentModel.getName(), extensionModel.getName(), this.extensionNamespace + ":" + errorDefinition), this.getExceptionCause((Throwable)exception));
            };
        });
    }

    public Throwable processException(Throwable throwable) {
        if (throwable instanceof org.mule.runtime.extension.api.exception.ModuleException) {
            return this.handleTypedException(throwable, ((org.mule.runtime.extension.api.exception.ModuleException)throwable).getType());
        }
        if (throwable instanceof ModuleException) {
            return this.handleTypedException(throwable, ((ModuleException)throwable).getType());
        }
        return throwable;
    }

    private Throwable handleTypedException(Throwable exception, ErrorTypeDefinition<?> errorDefinition) {
        return this.handleTypedException(exception, SdkErrorTypeDefinitionAdapter.from(errorDefinition));
    }

    private Throwable handleTypedException(Throwable exception, org.mule.sdk.api.error.ErrorTypeDefinition<?> errorDefinition) {
        return new TypedException(this.getExceptionCause(exception), (ErrorType)((Function)this.errorTypeCache.get(errorDefinition)).apply(exception));
    }

    private boolean isAllowedError(ErrorType errorType) {
        return this.allowedErrorTypes.stream().anyMatch(errorModel -> {
            boolean isAllowed = false;
            for (ErrorType currentError = errorType; currentError != null && !isAllowed; currentError = currentError.getParentErrorType()) {
                isAllowed = errorModel.getType().equals(currentError.getIdentifier()) && errorModel.getNamespace().equals(currentError.getNamespace());
            }
            return isAllowed;
        });
    }

    private Throwable getExceptionCause(Throwable throwable) {
        if (throwable.getClass().equals(org.mule.runtime.extension.api.exception.ModuleException.class) || throwable.getClass().equals(ModuleException.class)) {
            return throwable.getCause() != null && (throwable.getCause().getMessage() != null || throwable.getMessage() == null) ? this.suppressMessagingException(throwable.getCause()) : new MuleRuntimeException(I18nMessageFactory.createStaticMessage(throwable.getMessage()), throwable.getCause());
        }
        return this.suppressMessagingException(throwable);
    }

    private Throwable suppressMessagingException(Throwable throwable) {
        if (this.suppressErrors) {
            return ExceptionHelper.suppressIfPresent(throwable, MessagingException.class);
        }
        return throwable;
    }
}

