/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.internal.event.DefaultEventContext;
import org.mule.runtime.core.internal.event.EventQuickCopy;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.module.extension.api.runtime.privileged.ChildContextChain;
import org.mule.runtime.module.extension.api.runtime.privileged.EventedResult;
import org.mule.runtime.module.extension.internal.runtime.execution.SdkInternalContext;
import org.mule.runtime.module.extension.internal.runtime.operation.ChainExecutor;
import org.mule.runtime.module.extension.internal.runtime.operation.ImmutableProcessorChainExecutor;
import org.mule.runtime.module.extension.internal.runtime.operation.ProcessorChainExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableProcessorChildContextChainExecutor
implements ChildContextChain,
ProcessorChainExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmutableProcessorChildContextChainExecutor.class);
    private final MessageProcessorChain chain;
    private final CoreEvent originalEvent;
    private final BaseEventContext oldContext;
    private final ChainExecutor chainExecutor;
    private final ProcessorChainExecutor delegate;
    private final ComponentLocation location;

    public ImmutableProcessorChildContextChainExecutor(StreamingManager streamingManager, CoreEvent event, MessageProcessorChain chain) {
        this.originalEvent = event;
        this.chain = chain;
        this.oldContext = (BaseEventContext)this.originalEvent.getContext();
        this.delegate = new ImmutableProcessorChainExecutor(streamingManager, this.originalEvent, this.chain);
        this.location = (ComponentLocation)chain.getAnnotation(CHAIN_OWNER_LOCATION_KEY);
        this.chainExecutor = new ChainExecutor(chain, this.originalEvent);
    }

    private void setSdkInternalContextValues(CoreEvent eventWithCorrelationId) {
        String eventId = eventWithCorrelationId.getContext().getId();
        SdkInternalContext sdkInternalContext = SdkInternalContext.from(eventWithCorrelationId);
        sdkInternalContext.putContext(this.location, eventId);
        SdkInternalContext.OperationExecutionParams params = sdkInternalContext.getOperationExecutionParams(this.location, this.originalEvent.getContext().getId());
        if (params != null) {
            sdkInternalContext.setOperationExecutionParams(this.location, eventId, params.getConfiguration(), params.getParameters(), eventWithCorrelationId, params.getCallback(), params.getExecutionContextAdapter());
        }
    }

    private CoreEvent withPreviousCorrelationid(CoreEvent event) {
        return CoreEvent.builder(this.originalEvent).variables(event.getVariables()).message(event.getMessage()).build();
    }

    private EventedResult resultWithPreviousCorrelationId(EventedResult result) {
        return EventedResult.from(this.withPreviousCorrelationid(result.getEvent()));
    }

    private EventContext createCorrelationIdContext(String correlationId) {
        return DefaultEventContext.child(this.oldContext, Optional.ofNullable(this.location), correlationId);
    }

    @Override
    public void process(String correlationId, Consumer<Result> onSuccess, BiConsumer<Throwable, Result> onError) {
        CoreEvent eventWithCorrelationId = EventQuickCopy.quickCopy(this.createCorrelationIdContext(correlationId), this.originalEvent);
        this.setSdkInternalContextValues(eventWithCorrelationId);
        LOGGER.debug("Changing event correlationId from '{}' to '{}' in location {}", new Object[]{this.originalEvent.getCorrelationId(), correlationId, this.location.getLocation()});
        this.chainExecutor.execute(eventWithCorrelationId, result -> {
            LOGGER.debug("Event with correlationId '{}' going back to '{}' (successful execution) in location {}", new Object[]{correlationId, this.originalEvent.getCorrelationId(), this.location.getLocation()});
            ((BaseEventContext)eventWithCorrelationId.getContext()).success(eventWithCorrelationId);
            onSuccess.accept(this.resultWithPreviousCorrelationId((EventedResult)result));
        }, (t, res) -> {
            if (t instanceof MessagingException) {
                t = new MessagingException(this.withPreviousCorrelationid(((MessagingException)t).getEvent()), (Throwable)t);
            }
            ((BaseEventContext)eventWithCorrelationId.getContext()).error((Throwable)t);
            LOGGER.debug("Event with correlationId '{}' going back to '{}' (unsuccessful execution) in location {}", new Object[]{correlationId, this.originalEvent.getCorrelationId(), this.location.getLocation()});
            onError.accept((Throwable)t, this.resultWithPreviousCorrelationId((EventedResult)res));
        });
    }

    @Override
    public void process(Consumer<Result> onSuccess, BiConsumer<Throwable, Result> onError) {
        this.delegate.process(onSuccess, onError);
    }

    @Override
    public void process(Object payload, Object attributes, Consumer<Result> onSuccess, BiConsumer<Throwable, Result> onError) {
        this.delegate.process(payload, attributes, onSuccess, onError);
    }

    @Override
    public void process(Result input, Consumer<Result> onSuccess, BiConsumer<Throwable, Result> onError) {
        this.delegate.process(input, onSuccess, onError);
    }

    @Override
    public List<Processor> getMessageProcessors() {
        return this.chain.getMessageProcessors();
    }

    @Override
    public CoreEvent getOriginalEvent() {
        return this.originalEvent;
    }
}

