/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher.splash;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.util.NetworkUtils;
import org.mule.runtime.core.internal.util.splash.SplashScreen;
import org.mule.runtime.module.tls.internal.util.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleContainerStartupSplashScreen
extends SplashScreen {
    private Logger LOGGER = LoggerFactory.getLogger(MuleContainerStartupSplashScreen.class);
    private final List<String> additionalSplashEntries;

    public MuleContainerStartupSplashScreen(List<String> additionalSplashEntries) {
        this.additionalSplashEntries = additionalSplashEntries;
    }

    public void doBody() {
        try (InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("banner.txt");){
            LineIterator lineIterator = IOUtils.lineIterator((InputStream)resourceAsStream, (Charset)Charset.defaultCharset());
            while (lineIterator.hasNext()) {
                this.doBody(lineIterator.nextLine());
            }
        }
        catch (IOException e) {
            this.LOGGER.warn("Could not create banner");
        }
        String notset = CoreMessages.notSet().getMessage();
        Manifest mf = MuleManifest.getManifest();
        Attributes att = mf.getMainAttributes();
        if (att.values().size() > 0) {
            this.doBody(StringUtils.defaultString((String)MuleManifest.getProductDescription(), (String)notset));
            this.doBody(String.format("%s Build: %s", CoreMessages.version().getMessage(), StringUtils.defaultString((String)MuleManifest.getBuildNumber(), (String)notset)));
            this.doBody(StringUtils.defaultString((String)MuleManifest.getVendorName(), (String)notset));
            this.doBody(StringUtils.defaultString((String)MuleManifest.getProductMoreInfo(), (String)notset));
        } else {
            this.doBody(CoreMessages.versionNotSet().getMessage());
        }
        this.doBody(" ");
        this.doBody(CoreMessages.serverStartedAt(System.currentTimeMillis()).getMessage());
        this.doBody(String.format("JDK: %s (%s)", System.getProperty("java.version"), System.getProperty("java.vm.info")));
        this.listJavaSystemProperties();
        String patch = System.getProperty("sun.os.patch.level", null);
        this.doBody(String.format("OS: %s%s (%s, %s)", System.getProperty("os.name"), patch != null && !"unknown".equalsIgnoreCase(patch) ? " - " + patch : "", System.getProperty("os.version"), System.getProperty("os.arch")));
        for (String additionalEntry : this.additionalSplashEntries) {
            this.doBody(additionalEntry);
        }
        try {
            InetAddress host = NetworkUtils.getLocalHost();
            this.doBody(String.format("Host: %s (%s)", host.getHostName(), host.getHostAddress()));
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (!SecurityUtils.isDefaultSecurityModel()) {
            this.doBody("Security model: " + SecurityUtils.getSecurityModel());
        }
        if (RUNTIME_VERBOSE_PROPERTY.isEnabled()) {
            this.listServicesIfPresent();
            this.listServerPluginsIfPresent();
            this.listPatchesIfPresent();
            this.listMuleSystemProperties();
        }
    }

    private void listServerPluginsIfPresent() {
        File serverPluginsFolder = MuleFoldersUtil.getServerPluginsFolder();
        if (serverPluginsFolder != null && serverPluginsFolder.exists()) {
            this.listItems(Arrays.asList(serverPluginsFolder.list()), "Mule server plugins:");
        }
    }

    private void listServicesIfPresent() {
        File servicesDirectory = MuleFoldersUtil.getServicesFolder();
        if (servicesDirectory != null && servicesDirectory.exists()) {
            this.listItems(Arrays.asList(servicesDirectory.list()), "Mule services:");
        }
    }

    private void listPatchesIfPresent() {
        this.listPatchesIn(MuleFoldersUtil.getPatchesLibFolder(), "Applied patches:", (dir, name) -> !"mule-artifact-patches".equals(name));
        this.listPatchesIn(MuleFoldersUtil.getArtifactPatchesLibFolder(), "Applied artifact patches:", (dir, name) -> true);
    }

    private void listPatchesIn(File patchesDirectory, String description, FilenameFilter filenameFilter) {
        if (patchesDirectory != null && patchesDirectory.exists()) {
            Object[] patches = patchesDirectory.list(filenameFilter);
            Arrays.sort(patches);
            this.listItems(Arrays.asList(patches), description);
        }
    }

    private void listMuleSystemProperties() {
        HashMap<String, String> muleProperties = new HashMap<String, String>();
        System.getProperties().stringPropertyNames().stream().filter(property -> property.startsWith("mule.")).forEach(property -> muleProperties.put((String)property, System.getProperty(property)));
        this.listItems(muleProperties, "Mule system properties:");
    }

    private void listJavaSystemProperties() {
        this.listItems(Stream.of("java.vendor", "java.vm.name", "java.home").collect(Collectors.toMap(String::toString, propertyName -> System.getProperty(propertyName))), "JDK properties:");
    }
}

