/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.artifact;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.module.artifact.api.classloader.ModuleLayerInformationSupplier;

public class ModuleLayerGraph
implements ModuleLayerInformationSupplier {
    private static final String REPETITION = "*";
    private static final Map<ModuleLayer, String> ids = new HashMap();
    private final Map<ModuleLayer, List<ModuleLayer>> nodes = new HashMap();
    private final ModuleLayer rootNode;

    public ModuleLayerGraph(ModuleLayer layer) {
        this.addModuleLayerAndParents(layer);
        this.rootNode = layer;
    }

    public static void setModuleLayerId(ModuleLayer layer, String id) {
        ids.put(layer, id);
    }

    private void addModuleLayerAndParents(ModuleLayer layer) {
        ArrayList<ModuleLayer> parents = new ArrayList<ModuleLayer>();
        this.nodes.put(layer, parents);
        if (this.isFilteredLayer(layer)) {
            return;
        }
        String name = ids.getOrDefault(layer, Integer.toString(this.nodes.size()));
        if (!ids.containsKey(layer)) {
            ids.put(layer, name);
        }
        for (ModuleLayer parent : layer.parents()) {
            if (!this.nodes.containsKey(parent)) {
                this.addModuleLayerAndParents(parent);
            }
            parents.add(parent);
        }
    }

    public String graphString() {
        LinkedList<ModuleLayer> moduleLayers = new LinkedList<ModuleLayer>();
        int maximumIdLength = this.getMaxLength(this.rootNode, new HashSet());
        int frameSize = maximumIdLength + 5;
        moduleLayers.add(this.rootNode);
        StringBuilder stringBuilder = new StringBuilder();
        HashMap printAtLevel = new HashMap();
        HashMap maxPrintAtLevel = new HashMap();
        this.dfsDefinePrintLevel(this.rootNode, printAtLevel, maxPrintAtLevel, 0);
        List layersToPrintByLevel = this.layerPerLevel(printAtLevel);
        int currentLevel = 0;
        while (!moduleLayers.isEmpty()) {
            LinkedList nextLevel = new LinkedList();
            Set correspondingToLevel = (Set)layersToPrintByLevel.get(currentLevel);
            this.sortLayersByDepth(moduleLayers, correspondingToLevel, maxPrintAtLevel);
            this.printNodeFrame(stringBuilder, frameSize, moduleLayers, correspondingToLevel);
            this.printNodeDelegates(stringBuilder, frameSize, moduleLayers, correspondingToLevel);
            while (!moduleLayers.isEmpty()) {
                ModuleLayer current = (ModuleLayer)moduleLayers.pop();
                if (!correspondingToLevel.contains(current)) continue;
                current.parents().stream().filter(layer -> !this.isFilteredLayer(layer)).forEach(nextLevel::add);
            }
            moduleLayers = nextLevel;
            ++currentLevel;
        }
        return stringBuilder.toString();
    }

    private int getMaxLength(ModuleLayer moduleLayer, Set<ModuleLayer> analysed) {
        int maximumIdLength = ((String)ids.get(moduleLayer)).length();
        for (ModuleLayer parent : (List)this.nodes.get(moduleLayer)) {
            if (this.isFilteredLayer(parent) || analysed.contains(moduleLayer)) continue;
            maximumIdLength = Math.max(maximumIdLength, this.getMaxLength(parent, analysed));
        }
        analysed.add(moduleLayer);
        return maximumIdLength;
    }

    private void printNodeFrame(StringBuilder stringBuilder, int frameSize, List<ModuleLayer> moduleLayers, Set<ModuleLayer> printables) {
        int i;
        for (int i2 = 0; i2 < moduleLayers.size(); ++i2) {
            stringBuilder.append(StringUtils.repeat((String)"-", (int)frameSize));
            if (i2 >= moduleLayers.size() - 1) continue;
            stringBuilder.append("  ");
        }
        stringBuilder.append(System.lineSeparator());
        HashSet<ModuleLayer> alreadyAnalyzed = new HashSet<ModuleLayer>();
        for (i = 0; i < moduleLayers.size(); ++i) {
            ModuleLayer layer = moduleLayers.get(i);
            stringBuilder.append("|").append(StringUtils.center((String)((String)ids.get(layer) + (printables.contains(layer) && !alreadyAnalyzed.contains(layer) ? "" : REPETITION)), (int)(frameSize - 2))).append("|");
            if (i < moduleLayers.size() - 1) {
                stringBuilder.append("  ");
            }
            alreadyAnalyzed.add(layer);
        }
        stringBuilder.append(System.lineSeparator());
        for (i = 0; i < moduleLayers.size(); ++i) {
            stringBuilder.append(StringUtils.repeat((String)"-", (int)frameSize));
            if (i >= moduleLayers.size() - 1) continue;
            stringBuilder.append("  ");
        }
        stringBuilder.append(System.lineSeparator());
    }

    private void printNodeDelegates(StringBuilder stringBuilder, int frameSize, List<ModuleLayer> moduleLayers, Set<ModuleLayer> printParentsOf) {
        int i;
        ArrayList positionOfParents = new ArrayList();
        int current = 0;
        for (ModuleLayer moduleLayer : moduleLayers) {
            ArrayList<Integer> pos = new ArrayList<Integer>();
            positionOfParents.add(pos);
            if (!printParentsOf.contains(moduleLayer)) continue;
            for (ModuleLayer parent : moduleLayer.parents()) {
                if (this.isFilteredLayer(parent)) continue;
                pos.add(current);
                ++current;
            }
        }
        int totalParents = current;
        if (totalParents == 0) {
            return;
        }
        int accumulatedParents = 0;
        for (i = 0; i < moduleLayers.size(); ++i) {
            stringBuilder.append(StringUtils.repeat((String)" ", (int)(frameSize / 2)));
            int parents = ((List)positionOfParents.get(i)).size();
            int parentsToRight = 0;
            if (parents > 0) {
                stringBuilder.append("|");
                parentsToRight = parents - (accumulatedParents >= (Integer)((List)positionOfParents.get(i)).get(0) ? 1 : 0);
            } else {
                stringBuilder.append(" ");
            }
            if (parentsToRight > 0) {
                stringBuilder.append(StringUtils.repeat((String)"-", (int)(frameSize * parentsToRight)));
            }
            if ((accumulatedParents += ((List)positionOfParents.get(i)).size()) >= totalParents) continue;
            stringBuilder.append(StringUtils.repeat((String)" ", (int)(frameSize / 2)));
        }
        stringBuilder.append(System.lineSeparator());
        for (i = 0; i < totalParents; ++i) {
            stringBuilder.append(StringUtils.repeat((String)" ", (int)(frameSize / 2)));
            stringBuilder.append("|");
            if (i >= totalParents - 1) continue;
            stringBuilder.append(StringUtils.repeat((String)" ", (int)(frameSize / 2)));
        }
        stringBuilder.append(System.lineSeparator());
        for (i = 0; i < totalParents; ++i) {
            stringBuilder.append(StringUtils.repeat((String)" ", (int)(frameSize / 2)));
            stringBuilder.append("V");
            if (i >= totalParents - 1) continue;
            stringBuilder.append(StringUtils.repeat((String)" ", (int)(frameSize / 2)));
        }
        stringBuilder.append(System.lineSeparator());
    }

    private void dfsDefinePrintLevel(ModuleLayer current, Map<ModuleLayer, Integer> levelToPrint, Map<ModuleLayer, Integer> maxLevelRoot, int currentLevel) {
        if (!levelToPrint.containsKey(current) || levelToPrint.get(current) < currentLevel) {
            levelToPrint.put(current, currentLevel);
            maxLevelRoot.put(current, currentLevel);
        }
        for (ModuleLayer parent : current.parents()) {
            this.dfsDefinePrintLevel(parent, levelToPrint, maxLevelRoot, currentLevel + 1);
            if (maxLevelRoot.get(parent) <= maxLevelRoot.get(current)) continue;
            maxLevelRoot.put(current, maxLevelRoot.get(parent));
        }
    }

    private List<Set<ModuleLayer>> layerPerLevel(Map<ModuleLayer, Integer> levelToPrint) {
        int max = 0;
        for (Integer level : levelToPrint.values()) {
            if (level <= max) continue;
            max = level;
        }
        ArrayList<Set<ModuleLayer>> result = new ArrayList<Set<ModuleLayer>>();
        for (int i = 0; i <= max; ++i) {
            result.add(new HashSet());
        }
        for (ModuleLayer layer : levelToPrint.keySet()) {
            ((Set)result.get(levelToPrint.get(layer))).add(layer);
        }
        return result;
    }

    public String moduleLayerModules() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Modules in each Module Layer:");
        stringBuilder.append(System.lineSeparator());
        HashSet<ModuleLayer> checked = new HashSet<ModuleLayer>();
        LinkedList<ModuleLayer> queue = new LinkedList<ModuleLayer>();
        queue.add(this.rootNode);
        checked.add(this.rootNode);
        while (!queue.isEmpty()) {
            ModuleLayer layer = (ModuleLayer)queue.pollFirst();
            stringBuilder.append((String)ids.get(layer));
            stringBuilder.append(": ");
            if (layer.modules().size() > 0) {
                stringBuilder.append(layer.modules().stream().map(Module::getName).collect(Collectors.joining(", ")));
            } else {
                stringBuilder.append("(Empty Layer)");
            }
            stringBuilder.append(System.lineSeparator());
            for (ModuleLayer parent : layer.parents()) {
                if (!ids.containsKey(parent) || checked.contains(parent)) continue;
                checked.add(parent);
                queue.add(parent);
            }
        }
        return stringBuilder.toString();
    }

    protected boolean isFilteredLayer(ModuleLayer layer) {
        return layer.equals(ModuleLayer.boot());
    }

    private void sortLayersByDepth(List<ModuleLayer> moduleLayers, Set<ModuleLayer> processedInThisLevel, Map<ModuleLayer, Integer> depth) {
        moduleLayers.sort((m1, m2) -> {
            if (processedInThisLevel.contains(m2)) {
                return 1;
            }
            if (processedInThisLevel.contains(m1)) {
                return -1;
            }
            return (Integer)depth.get(m1) - (Integer)depth.get(m2);
        });
        HashSet<ModuleLayer> alreadyAppeared = new HashSet<ModuleLayer>();
        ArrayList<ModuleLayer> moveToEnd = new ArrayList<ModuleLayer>();
        ListIterator<ModuleLayer> iter = moduleLayers.listIterator();
        while (iter.hasNext()) {
            ModuleLayer current = iter.next();
            if (alreadyAppeared.contains(current)) {
                moveToEnd.add(current);
                iter.remove();
                continue;
            }
            alreadyAppeared.add(current);
        }
        moduleLayers.addAll(moveToEnd);
    }

    @Override
    public String retrieveRepresentation() {
        return this.graphString() + System.lineSeparator() + this.moduleLayerModules();
    }
}

