/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.metadata.api.annotation.IntAnnotation;
import org.mule.metadata.api.annotation.NumberRangeAnnotation;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.ParameterResolutionException;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;

public class NumberParameterWithinRange
implements Validation {
    @Override
    public String getName() {
        return "Number parameter within range.";
    }

    @Override
    public String getDescription() {
        return "Value of a Number type parameter is within the defined range.";
    }

    @Override
    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    @Override
    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(comp -> comp.getModel(ParameterizedModel.class).map(pmzd -> pmzd.getParameterGroupModels().stream().flatMap(pmg -> pmg.getParameterModels().stream()).anyMatch(this::isDoValidation)).orElse(false));
    }

    @Override
    public List<ValidationResultItem> validateMany(ComponentAst component, ArtifactAst artifact) {
        return component.getModel(ParameterizedModel.class).map(pmzd -> ExtensionModelUtils.getGroupAndParametersPairs(pmzd).filter(groupAndParameter -> this.isDoValidation((ParameterModel)groupAndParameter.getSecond())).map(groupAndParameter -> new Pair<ParameterModel, ComponentParameterAst>((ParameterModel)groupAndParameter.getSecond(), component.getParameter(((ParameterGroupModel)groupAndParameter.getFirst()).getName(), ((ParameterModel)groupAndParameter.getSecond()).getName())))).orElse(Stream.empty()).map(param -> {
            if (this.numberOffRange((ParameterModel)param.getFirst(), (ComponentParameterAst)param.getSecond())) {
                return Optional.of(ValidationResultItem.create(component, (ComponentParameterAst)param.getSecond(), (Validation)this, String.format("Parameter '%s' in element <%s> value '%s' is not within expected range.", ((ParameterModel)param.getFirst()).getName(), component.getIdentifier().toString(), ((ComponentParameterAst)param.getSecond()).getResolvedRawValue())));
            }
            if (((ComponentParameterAst)param.getSecond()).getValueOrResolutionError().isRight() && ((ComponentParameterAst)param.getSecond()).getValueOrResolutionError().getRight().getRight() instanceof ComponentAst) {
                return this.validate((ComponentAst)((ComponentParameterAst)param.getSecond()).getValueOrResolutionError().getRight().getRight(), artifact);
            }
            return Optional.empty();
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private boolean numberOffRange(ParameterModel paramModel, ComponentParameterAst paramAst) {
        Optional value = paramAst.getValueOrResolutionError().getValue();
        if (paramAst == null || !value.isPresent()) {
            return false;
        }
        NumberWithinRangeVisitor visitor = new NumberWithinRangeVisitor(value);
        paramModel.getType().accept(visitor);
        return visitor.isValueOffRange();
    }

    protected boolean isDoValidation(ParameterModel pm) {
        NumberHasRangeVisitor visitor = new NumberHasRangeVisitor();
        pm.getType().accept(visitor);
        return visitor.hasRangeAnnotation();
    }

    private static final class NumberHasRangeVisitor
    extends MetadataTypeVisitor {
        private boolean rangeAnnotation = false;

        private NumberHasRangeVisitor() {
        }

        @Override
        public void visitNumber(NumberType numberType) {
            this.rangeAnnotation = numberType.getAnnotation(NumberRangeAnnotation.class).isPresent();
        }

        public boolean hasRangeAnnotation() {
            return this.rangeAnnotation;
        }
    }

    private static final class NumberWithinRangeVisitor
    extends MetadataTypeVisitor {
        private final Optional<Either<ParameterResolutionException, Number>> value;
        private boolean valueOffRange = true;

        private NumberWithinRangeVisitor(Optional<Either<ParameterResolutionException, Number>> value) {
            this.value = value;
        }

        public boolean isValueOffRange() {
            return this.valueOffRange;
        }

        @Override
        public void visitNumber(NumberType numberType) {
            NumberRangeAnnotation rangeAnnotation = numberType.getAnnotation(NumberRangeAnnotation.class).get();
            Number valueAsNumber = this.value.get().getRight();
            if (numberType.getAnnotation(IntAnnotation.class).isPresent()) {
                rangeAnnotation.getFrom().map(from -> valueAsNumber.longValue() < from.longValue()).ifPresent(v -> {
                    this.valueOffRange = v;
                });
                rangeAnnotation.getTo().map(to -> valueAsNumber.longValue() > to.longValue()).ifPresent(v -> {
                    this.valueOffRange = v;
                });
            } else {
                rangeAnnotation.getFrom().map(from -> valueAsNumber.doubleValue() < from.doubleValue()).ifPresent(v -> {
                    this.valueOffRange = v;
                });
                rangeAnnotation.getTo().map(to -> valueAsNumber.doubleValue() > to.doubleValue()).ifPresent(v -> {
                    this.valueOffRange = v;
                });
            }
        }
    }
}

