/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.attribute;

import java.util.regex.Pattern;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.el.ExpressionManagerSession;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.el.ExpressionLanguageUtils;
import org.mule.runtime.core.internal.util.attribute.AttributeEvaluatorDelegate;
import org.mule.runtime.core.internal.util.attribute.ExpressionAttributeEvaluatorDelegate;
import org.mule.runtime.core.internal.util.attribute.ParseAttributeEvaluatorDelegate;
import org.mule.runtime.core.internal.util.attribute.StaticAttributeEvaluatorDelegate;

public final class AttributeEvaluator {
    private static final Pattern SINGLE_EXPRESSION_REGEX_PATTERN = Pattern.compile("^#\\[(?:(?!#\\[).)*]$", 32);
    private static final Pattern SANITIZE_PATTERN = Pattern.compile("\r|\t");
    private final String attributeValue;
    private final DataType expectedDataType;
    private AttributeEvaluatorDelegate evaluator;
    private ExtendedExpressionManager expressionManager;

    public AttributeEvaluator(String attributeValue) {
        this(attributeValue, null);
    }

    public AttributeEvaluator(String attributeValue, DataType expectedDataType) {
        this.attributeValue = this.sanitize(attributeValue);
        this.expectedDataType = expectedDataType;
    }

    public AttributeEvaluator initialize(ExtendedExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
        this.evaluator = this.getEvaluator(this.expectedDataType);
        return this;
    }

    private String sanitize(String attributeValue) {
        if (attributeValue != null) {
            attributeValue = SANITIZE_PATTERN.matcher(attributeValue.trim()).replaceAll("");
        }
        return attributeValue;
    }

    private AttributeEvaluatorDelegate getEvaluator(DataType expectedDataType) {
        if (this.attributeValue != null) {
            if (SINGLE_EXPRESSION_REGEX_PATTERN.matcher(this.attributeValue).matches()) {
                return new ExpressionAttributeEvaluatorDelegate(ExpressionLanguageUtils.compile(this.attributeValue, this.expressionManager), expectedDataType);
            }
            if (this.isParseExpression(this.attributeValue)) {
                return new ParseAttributeEvaluatorDelegate(this.attributeValue);
            }
        }
        return new StaticAttributeEvaluatorDelegate(this.attributeValue);
    }

    private boolean isParseExpression(String attributeValue) {
        int beginExpression = attributeValue.indexOf("#[");
        if (beginExpression == -1) {
            return false;
        }
        String remainingString = attributeValue.substring(beginExpression + "#[".length());
        return remainingString.contains("]");
    }

    @Deprecated
    public <T> TypedValue<T> resolveTypedValueFromContext(BindingContext context) {
        return this.evaluator.resolve(context, this.expressionManager);
    }

    public <T> TypedValue<T> resolveTypedValue(ExpressionManagerSession session) {
        return this.evaluator.resolve(session);
    }

    public <T> TypedValue<T> resolveTypedValue(CoreEvent event) {
        return this.evaluator.resolve(event, this.expressionManager);
    }

    public <T> T resolveValue(CoreEvent event) {
        TypedValue<T> resolveTypedValue = this.resolveTypedValue(event);
        return resolveTypedValue.getValue();
    }

    public String getRawValue() {
        return this.attributeValue;
    }
}

