/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import java.lang.reflect.Type;
import java.util.Optional;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.tx.TransactionType;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.IdempotentDeclarationEnricherWalkDelegate;
import org.mule.runtime.extension.api.loader.WalkingDeclarationEnricher;
import org.mule.runtime.extension.api.tx.OperationTransactionalAction;
import org.mule.runtime.extension.internal.property.NoTransactionalActionModelProperty;
import org.mule.runtime.extension.internal.property.TransactionalActionModelProperty;
import org.mule.runtime.extension.internal.property.TransactionalTypeModelProperty;
import org.mule.sdk.api.tx.SourceTransactionalAction;

public final class TransactionalDeclarationEnricher
implements WalkingDeclarationEnricher {
    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.STRUCTURE;
    }

    @Override
    public Optional<WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate> getWalkDelegate(ExtensionLoadingContext extensionLoadingContext) {
        return Optional.of(new IdempotentDeclarationEnricherWalkDelegate(){
            final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
            final MetadataType operationTransactionalActionType = this.typeLoader.load((Type)((Object)OperationTransactionalAction.class));
            final MetadataType sourceTransactionalActionType = this.typeLoader.load((Type)((Object)org.mule.runtime.extension.api.tx.SourceTransactionalAction.class));
            final MetadataType sdkOperationTransactionalActionType = this.typeLoader.load((Type)((Object)org.mule.sdk.api.tx.OperationTransactionalAction.class));
            final MetadataType sdkSourceTransactionalActionType = this.typeLoader.load((Type)((Object)SourceTransactionalAction.class));
            final MetadataType transactionType = this.typeLoader.load((Type)((Object)TransactionType.class));

            @Override
            protected void onSource(SourceDeclaration declaration) {
                TransactionalDeclarationEnricher.this.addTxParameter("transactionalAction", this.sourceTransactionalActionType, this.sdkSourceTransactionalActionType, (Object)org.mule.runtime.extension.api.tx.SourceTransactionalAction.NONE, (Object)SourceTransactionalAction.NONE, "The type of beginning action that sources can take regarding transactions.", declaration, new TransactionalActionModelProperty());
                TransactionalDeclarationEnricher.this.addTxParameter("transactionType", null, this.transactionType, null, (Object)TransactionType.LOCAL, "The type of transaction to create. Availability will depend on the runtime version.", declaration, new TransactionalTypeModelProperty());
            }

            @Override
            protected void onOperation(OperationDeclaration declaration) {
                TransactionalDeclarationEnricher.this.addTxParameter("transactionalAction", this.operationTransactionalActionType, this.sdkOperationTransactionalActionType, (Object)OperationTransactionalAction.JOIN_IF_POSSIBLE, (Object)org.mule.sdk.api.tx.OperationTransactionalAction.JOIN_IF_POSSIBLE, "The type of joining action that operations can take regarding transactions.", declaration, new TransactionalActionModelProperty());
            }
        });
    }

    private void addTxParameter(String parameterName, MetadataType metadataType, MetadataType sdkMetadataType, Object defaultValue, Object sdkDefaultValue, String description, ExecutableComponentDeclaration<?> declaration, ModelProperty modelProperty) {
        if (!declaration.isTransactional() || declaration.getModelProperty(NoTransactionalActionModelProperty.class).isPresent()) {
            return;
        }
        Optional<ParameterDeclaration> parameterDeclaration = this.isPresent(declaration, metadataType);
        Optional<ParameterDeclaration> sdkParameterDeclaration = this.isPresent(declaration, sdkMetadataType);
        if (parameterDeclaration.isPresent() && sdkParameterDeclaration.isPresent()) {
            throw new IllegalModelDefinitionException(String.format("Component '%s' has transactional parameters from different APIs. Offending parameters are '%s' and '%s'.", declaration.getName(), parameterDeclaration.get().getName(), sdkParameterDeclaration.get().getName()));
        }
        if (parameterDeclaration.isPresent()) {
            this.enrichTransactionParameter(defaultValue, description, parameterDeclaration.get(), modelProperty);
        } else if (sdkParameterDeclaration.isPresent()) {
            this.enrichTransactionParameter(sdkDefaultValue, description, sdkParameterDeclaration.get(), modelProperty);
        } else {
            ParameterDeclaration transactionParameter = new ParameterDeclaration(parameterName);
            transactionParameter.setType(sdkMetadataType, false);
            this.enrichTransactionParameter(sdkDefaultValue, description, transactionParameter, modelProperty);
            declaration.getParameterGroup("General").addParameter(transactionParameter);
        }
    }

    private void enrichTransactionParameter(Object defaultValue, String description, ParameterDeclaration transactionParameter, ModelProperty modelProperty) {
        transactionParameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        transactionParameter.setRequired(false);
        transactionParameter.setDefaultValue(defaultValue);
        transactionParameter.setDescription(description);
        transactionParameter.addModelProperty(modelProperty);
        transactionParameter.setLayoutModel(LayoutModel.builder().tabName("Advanced").build());
    }

    private Optional<ParameterDeclaration> isPresent(ComponentDeclaration<?> declaration, MetadataType metadataType) {
        if (metadataType == null) {
            return Optional.empty();
        }
        return declaration.getParameterGroups().stream().flatMap(group -> group.getParameters().stream()).filter(parameterDeclaration -> parameterDeclaration.getType().equals(metadataType)).findAny();
    }
}

