/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.function.Consumer;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.exception.InternalExceptionUtils;
import org.mule.runtime.core.internal.execution.ExceptionCallback;
import org.mule.runtime.core.internal.execution.MessageProcessContext;
import org.mule.runtime.core.internal.execution.ResponseCompletionCallback;
import org.mule.runtime.core.privileged.exception.MessagingException;

class ExtensionSourceExceptionCallback
implements ExceptionCallback {
    private final ResponseCompletionCallback completionCallback;
    private final CoreEvent event;
    private final Consumer<MessagingException> errorResponseHandler;
    private final MessageProcessContext messageProcessorContext;

    public ExtensionSourceExceptionCallback(ResponseCompletionCallback completionCallback, CoreEvent event, Consumer<MessagingException> errorResponseCallback, MessageProcessContext messageProcessContext) {
        this.completionCallback = completionCallback;
        this.event = event;
        this.errorResponseHandler = errorResponseCallback;
        this.messageProcessorContext = messageProcessContext;
    }

    public void onException(Throwable exception) {
        MessagingException messagingException = exception instanceof MessagingException ? (MessagingException)exception : new MessagingException(this.event, exception);
        CoreEvent errorEvent = InternalExceptionUtils.createErrorEvent(this.event, this.messageProcessorContext.getMessageSource(), messagingException, this.messageProcessorContext.getErrorTypeLocator());
        messagingException.setProcessedEvent(errorEvent);
        CoreEvent errorHandlingEvent = this.completionCallback.responseSentWithFailure(messagingException, errorEvent);
        messagingException.setProcessedEvent(errorHandlingEvent);
        this.errorResponseHandler.accept(messagingException);
    }
}

