/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.scheduler.SchedulingStrategy;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.core.api.source.scheduler.FixedFrequencyScheduler;
import org.mule.runtime.core.internal.util.FunctionalUtils;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.tx.SourceTransactionalAction;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ResolverSetBasedObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.runtime.source.legacy.SdkSourceAdapterFactory;
import org.mule.runtime.module.extension.internal.runtime.source.legacy.SourceTransactionalActionUtils;
import org.mule.runtime.module.extension.internal.runtime.source.poll.PollingSourceWrapper;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.sdk.api.runtime.source.PollingSource;
import org.mule.sdk.api.runtime.source.Source;

public final class SourceConfigurer {
    private final SourceModel model;
    private final ResolverSet resolverSet;
    private final ComponentLocation componentLocation;
    private final ExpressionManager expressionManager;
    private final MuleContext muleContext;
    private final boolean restarting;

    public SourceConfigurer(SourceModel model, ComponentLocation componentLocation, ResolverSet resolverSet, ExpressionManager expressionManager, MuleContext muleContext) {
        this(model, componentLocation, resolverSet, expressionManager, muleContext, false);
    }

    public SourceConfigurer(SourceModel model, ComponentLocation componentLocation, ResolverSet resolverSet, ExpressionManager expressionManager, MuleContext muleContext, boolean restarting) {
        this.model = model;
        this.resolverSet = resolverSet;
        this.componentLocation = componentLocation;
        this.expressionManager = expressionManager;
        this.muleContext = muleContext;
        this.restarting = restarting;
    }

    public Source configure(final Object source, final Optional<ConfigurationInstance> config) {
        ResolverSetBasedObjectBuilder<Object> builder = new ResolverSetBasedObjectBuilder<Object>(source.getClass(), (ParameterizedModel)this.model, this.resolverSet, this.expressionManager, this.muleContext){

            @Override
            protected Object instantiateObject() {
                return source;
            }

            @Override
            public Object build(ValueResolvingContext context) throws MuleException {
                Object builtSource = this.build(SourceConfigurer.this.buildResolverSetResult(source, context));
                IntrospectionUtils.injectDefaultEncoding(SourceConfigurer.this.model, builtSource, SourceConfigurer.this.muleContext.getConfiguration().getDefaultEncoding());
                IntrospectionUtils.injectRuntimeVersion(SourceConfigurer.this.model, builtSource, MuleExtensionModelProvider.getMuleVersion());
                IntrospectionUtils.injectComponentLocation(builtSource, SourceConfigurer.this.componentLocation);
                config.ifPresent(c -> IntrospectionUtils.injectRefName(builtSource, c.getName(), this.getReflectionCache()));
                return builtSource;
            }
        };
        return FunctionalUtils.withNullEvent(event -> {
            ValueResolvingContext context = ValueResolvingContext.builder(event, this.expressionManager).withConfig(config).build();
            try {
                Object configuredSource = builder.build(context);
                PollingSourceWrapper sdkSource = SdkSourceAdapterFactory.createAdapter(configuredSource);
                if (sdkSource instanceof PollingSource) {
                    ValueResolver<?> valueResolver = this.resolverSet.getResolvers().get("schedulingStrategy");
                    SchedulingStrategy scheduler = valueResolver == null ? new FixedFrequencyScheduler(60000L, 0L, TimeUnit.MILLISECONDS) : (SchedulingStrategy)valueResolver.resolve(context);
                    sdkSource = new PollingSourceWrapper((PollingSource)((Object)sdkSource), scheduler, this.resolverMaxItemsPerPoll(this.resolverSet, context, (CoreEvent)event), this.muleContext.getExceptionListener());
                }
                PollingSourceWrapper pollingSourceWrapper = sdkSource;
                if (context != null) {
                    context.close();
                }
                return pollingSourceWrapper;
            }
            catch (Throwable throwable) {
                try {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Exception was found trying to configure source of type " + source.getClass().getName()), (Throwable)e);
                }
            }
        });
    }

    private int resolverMaxItemsPerPoll(ResolverSet resolverSet, ValueResolvingContext context, CoreEvent event) throws MuleException {
        ValueResolver<?> valueResolver = resolverSet.getResolvers().get("maxItemsPerPoll");
        if (valueResolver == null) {
            return Integer.MAX_VALUE;
        }
        int maxItemsPerPoll = (Integer)valueResolver.resolve(context);
        if (maxItemsPerPoll < 1) {
            throw new IllegalArgumentException(String.format("The %s parameter must have a value greater than 1", "maxItemsPerPoll"));
        }
        return maxItemsPerPoll;
    }

    private ResolverSetResult buildResolverSetResult(Object source, ValueResolvingContext context) throws MuleException {
        ResolverSetResult resolverSetResult = this.resolverSet.resolve(context);
        Optional<Field> field = Arrays.stream(source.getClass().getDeclaredFields()).filter(f -> f.getType().getName().equals(SourceTransactionalAction.class.getName())).findFirst();
        if (field.isPresent() && this.resolverSet.getResolvers().get(field.get().getName()) != null) {
            return this.overwriteResolverResult(field.get().getName(), resolverSetResult);
        }
        return resolverSetResult;
    }

    private ResolverSetResult overwriteResolverResult(String fieldName, ResolverSetResult resolverSetResult) {
        ResolverSetResult.Builder builder = ResolverSetResult.newBuilder();
        for (Map.Entry<String, Object> entry : resolverSetResult.asMap().entrySet()) {
            if (entry.getKey().equals(fieldName)) {
                builder.add(entry.getKey(), (Object)SourceTransactionalActionUtils.toLegacy(entry.getValue()));
                continue;
            }
            builder.add(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }
}

