/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.manager;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.func.CheckedRunnable;
import org.mule.runtime.core.api.util.func.CheckedSupplier;
import org.mule.runtime.module.artifact.api.classloader.DisposableClassLoader;
import org.mule.runtime.module.service.api.discoverer.ServiceAssembly;
import org.mule.runtime.module.service.api.discoverer.ServiceResolutionError;
import org.mule.runtime.module.service.api.manager.ServiceProxyInvocationHandler;
import org.mule.runtime.module.service.api.manager.ServiceRegistry;
import org.mule.runtime.module.service.internal.manager.DefaultMethodInvoker;
import org.mule.runtime.module.service.internal.manager.DefaultServiceRegistry;
import org.mule.runtime.module.service.internal.manager.LazyServiceProxyApplicationDecorator;
import org.mule.runtime.module.service.internal.manager.MethodInvoker;
import org.mule.runtime.module.service.internal.manager.ServiceSplashScreen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyServiceProxy
implements ServiceProxyInvocationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LazyServiceProxy.class);
    private static final Logger SPLASH_LOGGER = LoggerFactory.getLogger((String)"org.mule.runtime.core.internal.logging");
    private final ServiceAssembly assembly;
    private final DefaultServiceRegistry serviceRegistry;
    private final LazyValue<Service> service;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private MethodInvoker methodInvoker = new DefaultMethodInvoker();

    public static Service from(ServiceAssembly assembly, ServiceRegistry serviceRegistry, Injector containerInjector) {
        return LazyServiceProxy.proxy(assembly, new LazyServiceProxy(assembly, (DefaultServiceRegistry)serviceRegistry, containerInjector));
    }

    private static Service proxy(ServiceAssembly assembly, InvocationHandler handler) {
        Class<? extends Service> contract = assembly.getServiceContract();
        return (Service)Proxy.newProxyInstance(contract.getClassLoader(), new Class[]{contract, Startable.class, Stoppable.class}, handler);
    }

    protected LazyServiceProxy(ServiceAssembly assembly, DefaultServiceRegistry serviceRegistry, Injector containerInjector) {
        this.assembly = assembly;
        this.serviceRegistry = serviceRegistry;
        this.service = new LazyValue<CheckedSupplier<Service>>(this.createService(containerInjector));
    }

    protected LazyServiceProxy(ServiceAssembly assembly, DefaultServiceRegistry serviceRegistry, LazyValue<Service> service) {
        this.assembly = assembly;
        this.serviceRegistry = serviceRegistry;
        this.service = service;
    }

    public Service forApplication(MethodInvoker methodInvoker) {
        return LazyServiceProxy.proxy(this.assembly, new LazyServiceProxyApplicationDecorator(this.assembly, this.serviceRegistry, this.service, methodInvoker));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> methodClass = method.getDeclaringClass();
        if (methodClass == Object.class && !method.getName().equals("toString")) {
            return method.invoke((Object)this, args);
        }
        if (methodClass == NamedObject.class) {
            return this.assembly.getName();
        }
        if (methodClass == Service.class) {
            return this.assembly.getServiceContract().getSimpleName();
        }
        if (methodClass == Startable.class) {
            return this.handleStart();
        }
        if (methodClass == Stoppable.class) {
            return this.handleStop();
        }
        return this.methodInvoker.invoke(this.getService(), method, args);
    }

    protected void setMethodInvoker(MethodInvoker methodInvoker) {
        this.methodInvoker = methodInvoker;
    }

    private CheckedSupplier<Service> createService(Injector containerInjector) {
        return () -> {
            Service serviceInstance = this.withServiceClassLoader(() -> this.instantiateService(containerInjector));
            if (this.started.compareAndSet(false, true)) {
                this.doStart(serviceInstance);
                this.stopped.set(false);
            }
            return serviceInstance;
        };
    }

    private Service instantiateService(Injector containerInjector) throws ServiceResolutionError, MuleException {
        ServiceProvider provider = this.assembly.getServiceProvider();
        this.serviceRegistry.inject(provider);
        Service serviceInstance = provider.getServiceDefinition().getService();
        if (containerInjector != null) {
            containerInjector.inject(serviceInstance);
        }
        return serviceInstance;
    }

    protected synchronized Object handleStart() {
        if (this.service.isComputed() && this.started.compareAndSet(false, true)) {
            this.doStart(this.getService());
            this.stopped.set(false);
        }
        return null;
    }

    protected Object handleStop() {
        if (this.stopped.compareAndSet(false, true) && this.service.isComputed()) {
            this.doStop();
            this.started.set(false);
        }
        return null;
    }

    private synchronized void doStart(Service service) {
        this.withServiceClassLoader(() -> {
            LifecycleUtils.startIfNeeded(service);
            String splash = service.getSplashMessage();
            if (StringUtils.isNotEmpty((CharSequence)splash)) {
                SPLASH_LOGGER.info(new ServiceSplashScreen(service.toString(), splash).toString());
            }
        });
    }

    private synchronized void doStop() {
        this.withServiceClassLoader(() -> {
            try {
                LifecycleUtils.stopIfNeeded(this.getService());
            }
            catch (Exception e) {
                LOGGER.warn(String.format("Service '%s' was not stopped properly: %s", this.assembly.getName(), e.getMessage()), (Throwable)e);
            }
            if (this.assembly.getClassLoader() instanceof DisposableClassLoader) {
                try {
                    ((DisposableClassLoader)((Object)this.assembly.getClassLoader())).dispose();
                }
                catch (Exception e) {
                    LOGGER.warn(String.format("Service '%s' class loader was not stopped properly: %s", this.assembly.getName(), e.getMessage()), (Throwable)e);
                }
            }
        });
    }

    private void withServiceClassLoader(CheckedRunnable task) {
        ClassUtils.withContextClassLoader(this.assembly.getClassLoader(), task);
    }

    private <T> T withServiceClassLoader(Callable<T> callable) {
        return ClassUtils.withContextClassLoader(this.assembly.getClassLoader(), callable);
    }

    public boolean equals(Object obj) {
        if (obj != null && Proxy.isProxyClass(obj.getClass())) {
            return this == Proxy.getInvocationHandler(obj);
        }
        return false;
    }

    @Override
    public Service getService() {
        return this.service.get();
    }
}

