/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.xml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.extension.internal.loader.xml.XmlExtensionLoaderDelegate;
import org.vibur.objectpool.PoolObjectFactory;

public class ForTnsTransformerFactory
implements PoolObjectFactory<Transformer> {
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
    private static final String TRANSFORMATION_FOR_TNS_RESOURCE = "META-INF/transform_for_tns.xsl";

    public Transformer create() {
        Transformer transformer;
        BufferedInputStream in = new BufferedInputStream(XmlExtensionLoaderDelegate.class.getClassLoader().getResourceAsStream(TRANSFORMATION_FOR_TNS_RESOURCE));
        try {
            transformer = TRANSFORMER_FACTORY.newTransformer(new StreamSource(in));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | TransformerException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("There was an issue creating the transformer to remove the content of the <body> element to generate an XSD", new Object[0])), (Throwable)e);
            }
        }
        ((InputStream)in).close();
        return transformer;
    }

    public boolean readyToTake(Transformer obj) {
        return true;
    }

    public boolean readyToRestore(Transformer obj) {
        return true;
    }

    public void destroy(Transformer obj) {
        obj.reset();
    }
}

